<!DOCTYPE html>
<html lang="en" data-theme="light">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($page_title) ? htmlspecialchars($page_title) . ' - ' : ''; ?>SCMS v3.0</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

    <!-- Custom Modern CSS with Dark Mode -->
    <style>
        :root[data-theme="light"] {
            --bg-primary: #ffffff;
            --bg-secondary: #f8f9fa;
            --bg-tertiary: #ffffff;
            --text-primary: #1a1a1a;
            --text-secondary: #6c757d;
            --text-muted: #9ca3af;
            --border-color: #e5e7eb;
            --shadow: rgba(0, 0, 0, 0.1);
            --shadow-lg: rgba(0, 0, 0, 0.15);
            --sidebar-bg: #ffffff;
            --sidebar-text: #6c757d;
            --sidebar-active: #667eea;
            --sidebar-hover: #f8f9fa;
            --card-bg: #ffffff;
            --navbar-bg: #ffffff;
        }

        :root[data-theme="dark"] {
            --bg-primary: #1a1b1e;
            --bg-secondary: #25262b;
            --bg-tertiary: #2c2e33;
            --text-primary: #ffffff;
            --text-secondary: #c1c2c5;
            --text-muted: #909296;
            --border-color: #373a40;
            --shadow: rgba(0, 0, 0, 0.3);
            --shadow-lg: rgba(0, 0, 0, 0.5);
            --sidebar-bg: #25262b;
            --sidebar-text: #c1c2c5;
            --sidebar-active: #667eea;
            --sidebar-hover: #2c2e33;
            --card-bg: #25262b;
            --navbar-bg: #25262b;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif;
            background: var(--bg-secondary);
            color: var(--text-primary);
            transition: background-color 0.3s ease, color 0.3s ease;
            overflow-x: hidden;
        }

        /* Sidebar Styles */
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            bottom: 0;
            width: 280px;
            background: var(--sidebar-bg);
            border-right: 1px solid var(--border-color);
            padding: 1.5rem 0;
            overflow-y: auto;
            z-index: 1000;
            transition: all 0.3s ease;
        }

        .sidebar-header {
            padding: 0 1.5rem 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.75rem;
            border-bottom: 1px solid var(--border-color);
            margin-bottom: 1.5rem;
        }

        .sidebar-logo {
            width: 40px;
            height: 40px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.25rem;
            font-weight: 700;
        }

        .sidebar-title {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--text-primary);
        }

        .sidebar-version {
            font-size: 0.75rem;
            color: var(--text-muted);
        }

        .sidebar-nav {
            padding: 0 1rem;
        }

        .nav-section-title {
            font-size: 0.75rem;
            font-weight: 600;
            color: var(--text-muted);
            text-transform: uppercase;
            letter-spacing: 0.05em;
            padding: 0.75rem 0.75rem 0.5rem;
        }

        .nav-link {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem;
            margin: 0.25rem 0;
            border-radius: 10px;
            color: var(--sidebar-text);
            text-decoration: none;
            font-weight: 500;
            font-size: 0.95rem;
            transition: all 0.2s ease;
            position: relative;
        }

        .nav-link i {
            font-size: 1.1rem;
            width: 20px;
        }

        .nav-link:hover {
            background: var(--sidebar-hover);
            color: var(--sidebar-active);
            transform: translateX(3px);
        }

        .nav-link.active {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }

        .nav-link.active i {
            color: white;
        }

        /* Top Navbar */
        .top-navbar {
            position: fixed;
            top: 0;
            left: 280px;
            right: 0;
            height: 70px;
            background: var(--navbar-bg);
            border-bottom: 1px solid var(--border-color);
            padding: 0 2rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
            z-index: 999;
            transition: all 0.3s ease;
        }

        .navbar-search {
            flex: 1;
            max-width: 500px;
            position: relative;
        }

        .navbar-search input {
            width: 100%;
            padding: 0.75rem 1rem 0.75rem 2.75rem;
            border-radius: 12px;
            border: 1px solid var(--border-color);
            background: var(--bg-secondary);
            color: var(--text-primary);
            font-size: 0.95rem;
            transition: all 0.2s ease;
        }

        .navbar-search input:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .navbar-search i {
            position: absolute;
            left: 1rem;
            top: 50%;
            transform: translateY(-50%);
            color: var(--text-muted);
        }

        .navbar-actions {
            display: flex;
            align-items: center;
            gap: 1rem;
        }

        .theme-toggle {
            width: 40px;
            height: 40px;
            border-radius: 10px;
            border: none;
            background: var(--bg-secondary);
            color: var(--text-primary);
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .theme-toggle:hover {
            background: var(--sidebar-hover);
            transform: scale(1.05);
        }

        .notifications-btn {
            position: relative;
            width: 40px;
            height: 40px;
            border-radius: 10px;
            border: none;
            background: var(--bg-secondary);
            color: var(--text-primary);
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .notifications-btn:hover {
            background: var(--sidebar-hover);
        }

        .notification-badge {
            position: absolute;
            top: -4px;
            right: -4px;
            width: 18px;
            height: 18px;
            border-radius: 50%;
            background: #ef4444;
            color: white;
            font-size: 0.7rem;
            font-weight: 600;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .user-menu {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.5rem 0.75rem;
            border-radius: 12px;
            background: var(--bg-secondary);
            border: none;
            cursor: pointer;
            transition: all 0.2s ease;
        }

        .user-menu:hover {
            background: var(--sidebar-hover);
        }

        .dropdown-menu {
            box-shadow: 0 8px 24px var(--shadow-lg);
            border: 1px solid var(--border-color);
            border-radius: 12px;
            padding: 0.5rem;
        }

        .dropdown-item {
            border-radius: 8px;
            padding: 0.5rem 1rem;
            transition: all 0.2s ease;
        }

        .dropdown-item:hover {
            background: var(--sidebar-hover);
        }

        .dropdown-item i {
            width: 20px;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 10px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
            font-size: 0.9rem;
        }

        .user-info {
            display: flex;
            flex-direction: column;
        }

        .user-name {
            font-weight: 600;
            font-size: 0.9rem;
            color: var(--text-primary);
        }

        .user-role {
            font-size: 0.75rem;
            color: var(--text-muted);
        }

        /* Main Content */
        .main-content {
            margin-left: 280px;
            margin-top: 70px;
            padding: 2rem;
            min-height: calc(100vh - 70px);
            transition: all 0.3s ease;
        }

        .dashboard-container {
            max-width: 1400px;
            margin: 0 auto;
        }

        /* Welcome Section */
        .welcome-section {
            background: var(--card-bg);
            border-radius: 20px;
            padding: 2rem;
            margin-bottom: 2rem;
            display: flex;
            justify-content: space-between;
            align-items: center;
            border: 1px solid var(--border-color);
            position: relative;
            overflow: hidden;
        }

        .welcome-section::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 400px;
            height: 100%;
            background: linear-gradient(135deg, rgba(102, 126, 234, 0.1) 0%, rgba(118, 75, 162, 0.1) 100%);
            border-radius: 50%;
            transform: translate(30%, -30%);
        }

        .welcome-content {
            position: relative;
            z-index: 1;
        }

        .welcome-title {
            font-size: 1.75rem;
            font-weight: 700;
            color: var(--text-primary);
            margin-bottom: 0.5rem;
        }

        .welcome-subtitle {
            color: var(--text-secondary);
            font-size: 1rem;
            margin: 0;
        }

        .system-status-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem 1.25rem;
            background: rgba(34, 197, 94, 0.1);
            color: #22c55e;
            border-radius: 50px;
            font-weight: 600;
            font-size: 0.9rem;
        }

        .pulse {
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.5; }
        }

        /* Statistics Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
            gap: 1.5rem;
            margin-bottom: 2rem;
        }

        .stat-card {
            background: var(--card-bg);
            border-radius: 20px;
            padding: 1.75rem;
            border: 1px solid var(--border-color);
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .stat-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 12px 24px var(--shadow-lg);
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
        }

        .gradient-blue::before { background: linear-gradient(90deg, #667eea 0%, #764ba2 100%); }
        .gradient-green::before { background: linear-gradient(90deg, #10b981 0%, #22c55e 100%); }
        .gradient-yellow::before { background: linear-gradient(90deg, #f59e0b 0%, #fbbf24 100%); }
        .gradient-red::before { background: linear-gradient(90deg, #ef4444 0%, #f87171 100%); }

        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 15px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.75rem;
            margin-bottom: 1rem;
            color: white;
        }

        .gradient-blue .stat-icon { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .gradient-green .stat-icon { background: linear-gradient(135deg, #10b981 0%, #22c55e 100%); }
        .gradient-yellow .stat-icon { background: linear-gradient(135deg, #f59e0b 0%, #fbbf24 100%); }
        .gradient-red .stat-icon { background: linear-gradient(135deg, #ef4444 0%, #f87171 100%); }

        .stat-value {
            font-size: 2.25rem;
            font-weight: 700;
            color: var(--text-primary);
            margin-bottom: 0.25rem;
        }

        .stat-label {
            color: var(--text-secondary);
            font-size: 0.95rem;
            font-weight: 500;
            margin-bottom: 1rem;
        }

        .stat-footer {
            padding-top: 1rem;
            border-top: 1px solid var(--border-color);
        }

        .stat-link {
            color: var(--sidebar-active);
            text-decoration: none;
            font-weight: 600;
            font-size: 0.9rem;
            transition: all 0.2s ease;
        }

        .stat-link:hover {
            gap: 0.5rem;
        }

        .stat-background {
            position: absolute;
            bottom: -20px;
            right: -20px;
            font-size: 120px;
            opacity: 0.05;
        }

        /* Modern Cards */
        .modern-card {
            background: var(--card-bg);
            border-radius: 20px;
            border: 1px solid var(--border-color);
            margin-bottom: 2rem;
            overflow: hidden;
        }

        .card-header-modern {
            padding: 1.5rem 2rem;
            border-bottom: 1px solid var(--border-color);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .card-title-modern {
            font-size: 1.15rem;
            font-weight: 700;
            color: var(--text-primary);
            margin: 0;
        }

        .card-subtitle-modern {
            font-size: 0.85rem;
            color: var(--text-muted);
            margin: 0.25rem 0 0;
        }

        .card-body-modern {
            padding: 2rem;
        }

        .card-footer-modern {
            padding: 1.5rem 2rem;
            border-top: 1px solid var(--border-color);
        }

        /* Capacity Badge */
        .capacity-badge {
            padding: 0.5rem 1rem;
            border-radius: 50px;
            font-weight: 600;
            font-size: 0.85rem;
        }

        .badge-success {
            background: rgba(34, 197, 94, 0.1);
            color: #22c55e;
        }

        .badge-warning {
            background: rgba(245, 158, 11, 0.1);
            color: #f59e0b;
        }

        .badge-danger {
            background: rgba(239, 68, 68, 0.1);
            color: #ef4444;
        }

        /* Modern Progress */
        .modern-progress {
            margin: 2rem 0;
        }

        .progress-track {
            height: 12px;
            background: var(--bg-secondary);
            border-radius: 50px;
            overflow: hidden;
            position: relative;
        }

        .progress-fill {
            height: 100%;
            border-radius: 50px;
            position: relative;
            transition: width 1s ease;
            display: flex;
            align-items: center;
            justify-content: flex-end;
            padding-right: 0.5rem;
        }

        .progress-success { background: linear-gradient(90deg, #10b981 0%, #22c55e 100%); }
        .progress-warning { background: linear-gradient(90deg, #f59e0b 0%, #fbbf24 100%); }
        .progress-danger { background: linear-gradient(90deg, #ef4444 0%, #f87171 100%); }

        .progress-label {
            color: white;
            font-size: 0.75rem;
            font-weight: 600;
        }

        .capacity-info {
            margin-bottom: 1.5rem;
        }

        .capacity-stats {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 1rem;
        }

        .capacity-stat {
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .capacity-number {
            font-size: 2rem;
            font-weight: 700;
            color: var(--text-primary);
        }

        .capacity-text {
            font-size: 0.85rem;
            color: var(--text-muted);
        }

        .capacity-divider {
            font-size: 2rem;
            color: var(--text-muted);
            font-weight: 300;
        }

        .license-info {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 1.5rem;
            padding-top: 1.5rem;
            border-top: 1px solid var(--border-color);
        }

        .license-type {
            color: var(--text-secondary);
            font-size: 0.9rem;
        }

        .license-warning {
            color: #ef4444;
            font-size: 0.85rem;
            font-weight: 600;
        }

        /* Attendance Card */
        .attendance-number {
            padding: 2rem 0;
        }

        .attendance-value {
            font-size: 3.5rem;
            font-weight: 700;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 0.5rem;
        }

        .attendance-label {
            color: var(--text-muted);
            font-size: 0.95rem;
            margin: 0;
        }

        /* Quick Actions */
        .quick-actions-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 1rem;
        }

        .quick-action-btn {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 1.5rem;
            border-radius: 15px;
            text-decoration: none;
            color: white;
            font-weight: 600;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }

        .quick-action-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255, 255, 255, 0.1);
            transform: translateX(-100%);
            transition: transform 0.3s ease;
        }

        .quick-action-btn:hover::before {
            transform: translateX(0);
        }

        .quick-action-btn:hover {
            transform: translateY(-4px);
            box-shadow: 0 12px 24px var(--shadow-lg);
        }

        .gradient-blue.quick-action-btn { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .gradient-green.quick-action-btn { background: linear-gradient(135deg, #10b981 0%, #22c55e 100%); }
        .gradient-purple.quick-action-btn { background: linear-gradient(135deg, #8b5cf6 0%, #a78bfa 100%); }
        .gradient-orange.quick-action-btn { background: linear-gradient(135deg, #f59e0b 0%, #fb923c 100%); }

        .quick-action-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            background: rgba(255, 255, 255, 0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
        }

        .quick-action-label {
            flex: 1;
            font-size: 1rem;
        }

        .quick-action-arrow {
            font-size: 1.25rem;
            opacity: 0.7;
        }

        /* Button Styles */
        .btn-modern-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            color: white;
            padding: 0.75rem 1.5rem;
            border-radius: 12px;
            font-weight: 600;
            font-size: 0.95rem;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.2s ease;
        }

        .btn-modern-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 16px rgba(102, 126, 234, 0.3);
            color: white;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .sidebar.active {
                transform: translateX(0);
            }

            .top-navbar {
                left: 0;
            }

            .main-content {
                margin-left: 0;
            }

            .navbar-search {
                display: none;
            }

            .welcome-section {
                flex-direction: column;
                text-align: center;
                gap: 1rem;
            }

            .stats-grid {
                grid-template-columns: 1fr;
            }

            .quick-actions-grid {
                grid-template-columns: 1fr;
            }
        }

        /* Modern Alert */
        .modern-alert {
            border-radius: 15px;
            border: none;
            box-shadow: 0 4px 12px var(--shadow);
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <div class="sidebar-logo">
                <i class="bi bi-shield-check"></i>
            </div>
            <div>
                <div class="sidebar-title">SCMS</div>
                <div class="sidebar-version">v3.0</div>
            </div>
        </div>

        <nav class="sidebar-nav">
            <div class="nav-section-title">Main</div>
            <a href="dashboard.php" class="nav-link <?php echo $current_page === 'dashboard' ? 'active' : ''; ?>">
                <i class="bi bi-speedometer2"></i> Dashboard
            </a>
            <a href="workers.php" class="nav-link <?php echo $current_page === 'workers' ? 'active' : ''; ?>">
                <i class="bi bi-people"></i> Sponsored Workers
            </a>
            <a href="attendance.php" class="nav-link <?php echo $current_page === 'attendance' ? 'active' : ''; ?>">
                <i class="bi bi-clock-history"></i> Attendance
            </a>
            <a href="holidays.php" class="nav-link <?php echo $current_page === 'holidays' ? 'active' : ''; ?>">
                <i class="bi bi-calendar-event"></i> Holidays
            </a>
            <a href="documents.php" class="nav-link <?php echo $current_page === 'documents' ? 'active' : ''; ?>">
                <i class="bi bi-file-earmark-text"></i> Documents
            </a>
            <a href="locations.php" class="nav-link <?php echo $current_page === 'locations' ? 'active' : ''; ?>">
                <i class="bi bi-geo-alt"></i> Work Locations
            </a>
            <a href="cos.php" class="nav-link <?php echo $current_page === 'cos' ? 'active' : ''; ?>">
                <i class="bi bi-file-earmark-check"></i> CoS Management
            </a>

            <div class="nav-section-title mt-4">Compliance</div>
            <a href="reports.php" class="nav-link <?php echo $current_page === 'reports' ? 'active' : ''; ?>">
                <i class="bi bi-bar-chart"></i> Reports
            </a>
            <a href="ho_reports.php" class="nav-link <?php echo $current_page === 'ho_reports' ? 'active' : ''; ?>">
                <i class="bi bi-flag"></i> Home Office Reports
            </a>

            <div class="nav-section-title mt-4">System</div>
            <a href="users.php" class="nav-link <?php echo $current_page === 'users' ? 'active' : ''; ?>">
                <i class="bi bi-person-lock"></i> Users
            </a>
            <a href="settings.php" class="nav-link <?php echo $current_page === 'settings' ? 'active' : ''; ?>">
                <i class="bi bi-gear"></i> Settings
            </a>
        </nav>
    </div>

    <!-- Top Navbar -->
    <nav class="top-navbar">
        <div class="navbar-search">
            <i class="bi bi-search"></i>
            <input type="text" placeholder="Search workers, documents, or records...">
        </div>

        <div class="navbar-actions">
            <button class="theme-toggle" id="themeToggle" onclick="toggleTheme()">
                <i class="bi bi-moon-stars-fill" id="themeIcon"></i>
            </button>

            <button class="notifications-btn">
                <i class="bi bi-bell"></i>
                <span class="notification-badge">3</span>
            </button>

            <div class="dropdown">
                <button class="user-menu" data-bs-toggle="dropdown" aria-expanded="false">
                    <div class="user-avatar">
                        <?php
                        $initials = '';
                        if (isset($current_user['full_name'])) {
                            $names = explode(' ', $current_user['full_name']);
                            $initials = strtoupper(substr($names[0], 0, 1));
                            if (count($names) > 1) {
                                $initials .= strtoupper(substr($names[count($names) - 1], 0, 1));
                            }
                        }
                        echo $initials ?: 'U';
                        ?>
                    </div>
                    <div class="user-info">
                        <div class="user-name"><?php echo htmlspecialchars($current_user['full_name'] ?? 'User'); ?></div>
                        <div class="user-role">Admin</div>
                    </div>
                    <i class="bi bi-chevron-down"></i>
                </button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li>
                        <a class="dropdown-item" href="profile.php">
                            <i class="bi bi-person"></i> My Profile
                        </a>
                    </li>
                    <li>
                        <a class="dropdown-item" href="settings.php">
                            <i class="bi bi-gear"></i> Settings
                        </a>
                    </li>
                    <li><hr class="dropdown-divider"></li>
                    <li>
                        <a class="dropdown-item text-danger" href="logout.php">
                            <i class="bi bi-box-arrow-right"></i> Logout
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="main-content">
        <script>
            // Dark Mode Toggle
            function toggleTheme() {
                const html = document.documentElement;
                const icon = document.getElementById('themeIcon');
                const currentTheme = html.getAttribute('data-theme');
                const newTheme = currentTheme === 'light' ? 'dark' : 'light';

                html.setAttribute('data-theme', newTheme);
                localStorage.setItem('theme', newTheme);

                if (newTheme === 'dark') {
                    icon.className = 'bi bi-sun-fill';
                } else {
                    icon.className = 'bi bi-moon-stars-fill';
                }
            }

            // Load saved theme
            document.addEventListener('DOMContentLoaded', function() {
                const savedTheme = localStorage.getItem('theme') || 'light';
                const icon = document.getElementById('themeIcon');
                document.documentElement.setAttribute('data-theme', savedTheme);

                if (savedTheme === 'dark') {
                    icon.className = 'bi bi-sun-fill';
                }
            });
        </script>
