<?php
require_once 'config/database.php';

try {
    $stmt = $pdo->query("DESCRIBE " . DB_PREFIX . "sponsored_workers");
    $existing = [];
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $existing[] = $row['Field'];
    }

    if (!in_array('rtw_check_type', $existing)) {
        $pdo->exec("ALTER TABLE " . DB_PREFIX . "sponsored_workers ADD COLUMN rtw_check_type ENUM('initial', 'follow_up', 'not_required', 'pending') DEFAULT 'pending'");
        echo "✓ Added rtw_check_type\n";
    }

    if (!in_array('rtw_documents_verified', $existing)) {
        $pdo->exec("ALTER TABLE " . DB_PREFIX . "sponsored_workers ADD COLUMN rtw_documents_verified TEXT");
        echo "✓ Added rtw_documents_verified\n";
    }

    if (!in_array('rtw_checked_by', $existing)) {
        $pdo->exec("ALTER TABLE " . DB_PREFIX . "sponsored_workers ADD COLUMN rtw_checked_by VARCHAR(100)");
        echo "✓ Added rtw_checked_by\n";
    }

    echo "✓ RTW fields added successfully!\n";
} catch (PDOException $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
}
?>
