<?php
require_once 'config/database.php';

try {
    echo "=== Adding notes column to work_locations table ===\n";

    // Check if column already exists
    $stmt = $pdo->query("SHOW COLUMNS FROM scms_work_locations LIKE 'notes'");
    if ($stmt->rowCount() > 0) {
        echo "✓ Column 'notes' already exists!\n";
    } else {
        // Add the notes column
        $pdo->exec("ALTER TABLE scms_work_locations
                    ADD COLUMN notes TEXT NULL COMMENT 'Optional notes about the location' AFTER status");

        echo "✓ Column 'notes' added successfully!\n";
    }

    // Verify
    echo "\n=== Updated table structure ===\n";
    $stmt = $pdo->query("DESCRIBE scms_work_locations");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($columns as $col) {
        echo $col['Field'] . " - " . $col['Type'];
        if ($col['Field'] === 'notes') echo " ← NEW";
        echo "\n";
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
