<?php
require_once 'config/database.php';

try {
    echo "=== Adding missing columns to sponsored_workers table ===\n\n";

    // Check and add gender column
    $stmt = $pdo->query("SHOW COLUMNS FROM scms_sponsored_workers LIKE 'gender'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE scms_sponsored_workers
                    ADD COLUMN gender ENUM('male', 'female', 'other', 'prefer_not_to_say') NULL
                    AFTER date_of_birth");
        echo "✓ Added 'gender' column\n";
    } else {
        echo "✓ 'gender' column already exists\n";
    }

    // Check and add place_of_birth column
    $stmt = $pdo->query("SHOW COLUMNS FROM scms_sponsored_workers LIKE 'place_of_birth'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE scms_sponsored_workers
                    ADD COLUMN place_of_birth VARCHAR(100) NULL
                    AFTER gender");
        echo "✓ Added 'place_of_birth' column\n";
    } else {
        echo "✓ 'place_of_birth' column already exists\n";
    }

    // Check and add driving_license column
    $stmt = $pdo->query("SHOW COLUMNS FROM scms_sponsored_workers LIKE 'driving_license'");
    if ($stmt->rowCount() == 0) {
        $pdo->exec("ALTER TABLE scms_sponsored_workers
                    ADD COLUMN driving_license VARCHAR(50) NULL
                    AFTER ni_number");
        echo "✓ Added 'driving_license' column\n";
    } else {
        echo "✓ 'driving_license' column already exists\n";
    }

    echo "\n=== Verifying columns ===\n";
    $stmt = $pdo->query("SHOW COLUMNS FROM scms_sponsored_workers WHERE Field IN ('gender', 'place_of_birth', 'driving_license')");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($columns as $col) {
        echo "✓ " . $col['Field'] . " - " . $col['Type'] . "\n";
    }

    echo "\n=== Success! All columns added ===\n";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
