<?php
require_once 'config/database.php';

try {
    echo "=== Adding manager_id column to work_locations table ===\n";

    // Check if column already exists
    $stmt = $pdo->query("SHOW COLUMNS FROM scms_work_locations LIKE 'manager_id'");
    if ($stmt->rowCount() > 0) {
        echo "✓ Column manager_id already exists!\n";
    } else {
        // Add the column
        $pdo->exec("ALTER TABLE scms_work_locations
                    ADD COLUMN manager_id INT(11) DEFAULT NULL COMMENT 'Site manager (worker ID)' AFTER capacity");

        echo "✓ Column manager_id added successfully!\n";

        // Add index
        $pdo->exec("ALTER TABLE scms_work_locations
                    ADD INDEX `manager_id` (`manager_id`)");

        echo "✓ Index added for manager_id!\n";

        // Add foreign key constraint
        $pdo->exec("ALTER TABLE scms_work_locations
                    ADD CONSTRAINT `fk_location_manager`
                    FOREIGN KEY (`manager_id`) REFERENCES `scms_sponsored_workers` (`id`)
                    ON DELETE SET NULL");

        echo "✓ Foreign key constraint added!\n";
    }

    // Verify
    echo "\n=== Updated table structure ===\n";
    $stmt = $pdo->query("DESCRIBE scms_work_locations");
    $columns = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($columns as $col) {
        echo $col['Field'] . " - " . $col['Type'];
        if ($col['Field'] === 'manager_id') echo " ← NEW";
        echo "\n";
    }

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
