<?php
require_once 'config/database.php';

try {
    echo "Adding line_manager column...\n";
    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS line_manager VARCHAR(255) NULL AFTER manager_id");
    echo "✓ line_manager column added\n";

    // Verify
    $stmt = $pdo->query("SHOW COLUMNS FROM scms_sponsored_workers WHERE Field = 'line_manager'");
    if ($stmt->rowCount() > 0) {
        $col = $stmt->fetch(PDO::FETCH_ASSOC);
        echo "✓ Verified: " . $col['Field'] . " (" . $col['Type'] . ")\n";
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
