<?php
/**
 * Add License Key to System
 */
require_once 'config/database.php';

echo "=== LICENSE KEY SETUP ===\n\n";

// License details - update these
$license_key = 'SCMS-TEST-2025-EXPREMIT'; // Your license key
$license_domain = 'supix.co.uk';
$license_type = 'unlimited'; // or 'trial', 'paid'
$worker_limit = 999999; // unlimited
$license_customer = 'Supix Organization';
$license_expiry = '2026-12-31';

echo "Installing license configuration...\n\n";

$settings = [
    'license_key' => $license_key,
    'license_domain' => $license_domain,
    'license_type' => $license_type,
    'worker_limit' => $worker_limit,
    'license_customer' => $license_customer,
    'license_expiry' => $license_expiry,
    'last_license_validation' => date('Y-m-d H:i:s'),
    'system_health_status' => 'healthy'
];

$stmt = $pdo->prepare("INSERT INTO " . DB_PREFIX . "system_settings (setting_key, setting_value)
                       VALUES (?, ?)
                       ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)");

foreach ($settings as $key => $value) {
    $stmt->execute([$key, $value]);
    echo "✓ Set $key = $value\n";
}

echo "\n=== LICENSE INSTALLED ===\n";
echo "\nYou can now login at: https://supix.co.uk/sys/scms/\n";
echo "Username: abz\n";
echo "Password: L@nd@n123\n";
