<?php
require_once 'config/database.php';

try {
    // Add employment status and related fields
    $new_fields = [
        // Employment status tracking
        "employment_status ENUM('pre_employment', 'active', 'suspended', 'terminated', 'on_leave') DEFAULT 'active' AFTER status",
        "employment_status_date DATE AFTER employment_status",
        "employment_status_notes TEXT AFTER employment_status_date",

        // Pre-employment specific
        "awaiting_visa TINYINT(1) DEFAULT 0 AFTER employment_status_notes",
        "cos_issued_date DATE AFTER awaiting_visa",
        "cos_location ENUM('in_country', 'out_of_country') AFTER cos_issued_date",

        // Right to work tracking (enhanced)
        "rtw_check_type ENUM('initial', 'follow_up', 'not_required', 'pending') DEFAULT 'pending' AFTER right_to_work_checked",
        "rtw_documents_verified TEXT AFTER rtw_check_type",
        "rtw_checked_by VARCHAR(100) AFTER rtw_documents_verified",

        // Conversion tracking (pre-employment to employee)
        "converted_to_employee_date DATE AFTER employment_status_notes",
        "converted_from_pre_employment TINYINT(1) DEFAULT 0 AFTER converted_to_employee_date"
    ];

    foreach ($new_fields as $field_def) {
        try {
            $field_name = explode(' ', $field_def)[0];

            // Check if field exists
            $stmt = $pdo->query("DESCRIBE " . DB_PREFIX . "sponsored_workers");
            $existing_cols = [];
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $existing_cols[] = $row['Field'];
            }

            if (!in_array($field_name, $existing_cols)) {
                $sql = "ALTER TABLE " . DB_PREFIX . "sponsored_workers ADD COLUMN $field_def";
                $pdo->exec($sql);
                echo "✓ Added: $field_name\n";
            } else {
                echo "○ Exists: $field_name\n";
            }
        } catch (PDOException $e) {
            echo "✗ Error for $field_name: " . $e->getMessage() . "\n";
        }
    }

    echo "\n✓ Employment status fields update completed!\n";

} catch (PDOException $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    exit(1);
}
?>
