<?php
require_once 'config/database.php';

try {
    echo "=== Adding all missing columns to sponsored_workers table ===\n\n";

    // Passport fields
    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS passport_issue_date DATE NULL AFTER passport_number");
    echo "✓ passport_issue_date\n";

    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS passport_expiry DATE NULL AFTER passport_issue_date");
    echo "✓ passport_expiry\n";

    // Visa fields
    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS visa_number VARCHAR(50) NULL AFTER visa_type");
    echo "✓ visa_number\n";

    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS visa_issue_date DATE NULL AFTER visa_number");
    echo "✓ visa_issue_date\n";

    // BRP fields
    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS brp_number VARCHAR(50) NULL AFTER visa_expiry");
    echo "✓ brp_number\n";

    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS brp_expiry DATE NULL AFTER brp_number");
    echo "✓ brp_expiry\n";

    // Share code fields
    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS share_code VARCHAR(20) NULL AFTER brp_expiry");
    echo "✓ share_code\n";

    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS share_code_expiry DATE NULL AFTER share_code");
    echo "✓ share_code_expiry\n";

    // Employment fields
    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS probation_end_date DATE NULL AFTER start_date");
    echo "✓ probation_end_date\n";

    // Contact fields
    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS personal_email VARCHAR(255) NULL AFTER email");
    echo "✓ personal_email\n";

    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS mobile_phone VARCHAR(20) NULL AFTER phone");
    echo "✓ mobile_phone\n";

    // Emergency contact fields
    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS emergency_contact_relationship VARCHAR(50) NULL AFTER emergency_contact");
    echo "✓ emergency_contact_relationship\n";

    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS emergency_contact_address TEXT NULL AFTER emergency_contact_relationship");
    echo "✓ emergency_contact_address\n";

    // Secondary emergency contact
    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS secondary_emergency_contact VARCHAR(255) NULL AFTER emergency_phone");
    echo "✓ secondary_emergency_contact\n";

    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS secondary_emergency_phone VARCHAR(20) NULL AFTER secondary_emergency_contact");
    echo "✓ secondary_emergency_phone\n";

    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS secondary_emergency_relationship VARCHAR(50) NULL AFTER secondary_emergency_phone");
    echo "✓ secondary_emergency_relationship\n";

    // Banking fields
    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS bank_name VARCHAR(100) NULL AFTER emergency_phone");
    echo "✓ bank_name\n";

    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS bank_account_number VARCHAR(20) NULL AFTER bank_name");
    echo "✓ bank_account_number\n";

    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS bank_sort_code VARCHAR(10) NULL AFTER bank_account_number");
    echo "✓ bank_sort_code\n";

    // Notes field
    $pdo->exec("ALTER TABLE scms_sponsored_workers ADD COLUMN IF NOT EXISTS notes TEXT NULL AFTER status");
    echo "✓ notes\n";

    echo "\n=== All columns added successfully! ===\n";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
