<?php
/**
 * Activate Core Modules
 */
require_once 'config/database.php';
require_once 'includes/ModuleManager.php';

$moduleManager = new ModuleManager($pdo);

echo "=== ACTIVATING CORE MODULES ===\n\n";

$modules_to_activate = ['workers', 'rtw', 'locations', 'documents', 'holidays', 'attendance', 'cos'];

foreach ($modules_to_activate as $index => $module_id) {
    echo ($index + 1) . ". Activating $module_id...\n";
    $result = $moduleManager->activate($module_id);

    if ($result['success']) {
        // Set sort order
        $stmt = $pdo->prepare("UPDATE " . DB_PREFIX . "modules_registry SET sort_order = ? WHERE module_id = ?");
        $stmt->execute([($index + 1) * 10, $module_id]);
        echo "   ✓ " . $result['message'] . " (Order: " . (($index + 1) * 10) . ")\n";
    } else {
        echo "   ✗ " . $result['message'] . "\n";
    }
}

echo "\n=== ACTIVE MODULES ===\n";
$stmt = $pdo->query("SELECT module_id, name, status, sort_order FROM " . DB_PREFIX . "modules_registry WHERE status = 'active' ORDER BY sort_order");
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    echo sprintf("- %-12s | %-25s | Order: %d\n",
        $row['module_id'],
        $row['name'],
        $row['sort_order']
    );
}

echo "\n=== COMPLETE ===\n";
echo "All modules activated successfully!\n";
