<?php
require_once 'config/database.php';

// Activate all modules directly
$pdo->exec("UPDATE " . DB_PREFIX . "modules_registry SET status = 'active', activated_at = NOW()");

// Set proper sort order
$modules = [
    'workers' => 10,
    'rtw' => 20,
    'locations' => 30,
    'documents' => 40,
    'holidays' => 50,
    'attendance' => 60,
    'cos' => 70
];

foreach ($modules as $module_id => $order) {
    $stmt = $pdo->prepare("UPDATE " . DB_PREFIX . "modules_registry SET sort_order = ? WHERE module_id = ?");
    $stmt->execute([$order, $module_id]);
}

echo "All modules activated!\n\n";

$stmt = $pdo->query("SELECT module_id, name, status, sort_order FROM " . DB_PREFIX . "modules_registry ORDER BY sort_order");
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    echo $row['module_id'] . " - " . $row['name'] . " [" . $row['status'] . "] (Order: " . $row['sort_order'] . ")\n";
}
