<?php
/**
 * Test Step 1 Loading
 */
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// Simulate clicking "Continue to Installation" from Step 0
$_GET['step'] = 1;
$current_step = 1;

// Test if extract_root_domain function exists
if (!function_exists('extract_root_domain')) {
    function extract_root_domain($host) {
        $host = explode(':', $host)[0];
        $host = preg_replace('/^www\./', '', $host);
        if ($host === 'localhost' || filter_var($host, FILTER_VALIDATE_IP)) {
            return $host;
        }
        $parts = explode('.', $host);
        $count = count($parts);
        if ($count < 2) {
            return $host;
        }
        $two_part_tlds = array('co.uk', 'com.au', 'co.za', 'com.br', 'co.nz', 'ac.uk', 'gov.uk');
        if ($count >= 3) {
            $potential_tld = $parts[$count - 2] . '.' . $parts[$count - 1];
            if (in_array($potential_tld, $two_part_tlds)) {
                return $parts[$count - 3] . '.' . $parts[$count - 2] . '.' . $parts[$count - 1];
            }
        }
        return $parts[$count - 2] . '.' . $parts[$count - 1];
    }
}

echo "Testing Step 1 Loading...\n\n";

// Test extract_root_domain
$test_domain = extract_root_domain($_SERVER['HTTP_HOST']);
echo "Domain extracted: $test_domain\n\n";

echo "Now including install_step1.php...\n\n";

// Include the step file
include_once "install_step1.php";

echo "\n\nStep 1 loaded successfully!";
