<?php
/**
 * RIU Communication Test
 * Test if RIU reporting is working
 */

session_start();

// Set test license credentials
$_SESSION['license_key'] = $_SESSION['license_key'] ?? 'SCMS-TEST-2025-EXPREMIT';
$_SESSION['domain'] = $_SESSION['domain'] ?? 'supix.co.uk';

echo "<h2>RIU Communication Test</h2>";
echo "<pre>";

// Define RIU constants
if (!defined('RIU_CONTROL_PLANE_URL')) {
    define('RIU_CONTROL_PLANE_URL', 'https://supix.co.uk/sys/riu');
}
if (!defined('RIU_PRODUCT_ID')) {
    define('RIU_PRODUCT_ID', 'scms_v3');
}
if (!defined('RIU_VERSION')) {
    define('RIU_VERSION', '3.0.0');
}

echo "RIU Configuration:\n";
echo "- Control Plane URL: " . RIU_CONTROL_PLANE_URL . "\n";
echo "- Product ID: " . RIU_PRODUCT_ID . "\n";
echo "- Version: " . RIU_VERSION . "\n";
echo "- License Key: " . $_SESSION['license_key'] . "\n";
echo "- Domain: " . $_SESSION['domain'] . "\n\n";

// Test 1: Check if RIUClient exists
if (file_exists(__DIR__ . '/includes/RIUClient.php')) {
    echo "✓ RIUClient.php exists\n";
    require_once __DIR__ . '/includes/RIUClient.php';
} else {
    echo "✗ RIUClient.php NOT FOUND\n";
    exit;
}

// Test 2: Create RIU Client
try {
    $client = new RIUClient(
        RIU_CONTROL_PLANE_URL,
        RIU_PRODUCT_ID,
        $_SESSION['license_key'],
        $_SESSION['domain']
    );
    echo "✓ RIU Client instantiated\n\n";
} catch (Exception $e) {
    echo "✗ Failed to create RIU Client: " . $e->getMessage() . "\n";
    exit;
}

// Test 3: Report installation stage
echo "Testing reportStage()...\n";
try {
    $result = $client->reportStage('installing', RIU_VERSION, array(
        'current_step' => 'Test Step',
        'step_number' => 1,
        'total_steps' => 7,
        'test' => true
    ));
    echo "✓ reportStage() response:\n";
    print_r($result);
    echo "\n";
} catch (Exception $e) {
    echo "✗ reportStage() failed: " . $e->getMessage() . "\n";
}

// Test 4: Report progress
echo "Testing reportProgress()...\n";
try {
    $result = $client->reportProgress(
        'install',
        'running',
        'Test installation progress message',
        array('test' => true, 'timestamp' => date('Y-m-d H:i:s'))
    );
    echo "✓ reportProgress() response:\n";
    print_r($result);
    echo "\n";
} catch (Exception $e) {
    echo "✗ reportProgress() failed: " . $e->getMessage() . "\n";
}

// Test 5: Send heartbeat
echo "Testing heartbeat()...\n";
try {
    $result = $client->heartbeat(array(
        'test' => true,
        'timestamp' => date('Y-m-d H:i:s')
    ));
    echo "✓ heartbeat() response:\n";
    print_r($result);
    echo "\n";
} catch (Exception $e) {
    echo "✗ heartbeat() failed: " . $e->getMessage() . "\n";
}

echo "</pre>";
echo "<p><a href='install.php'>Back to Installer</a></p>";
?>
