<?php
$page_title = 'Worker Details';
require_once '../../includes/header.php';

$worker_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Fetch worker details
$stmt = $pdo->prepare("SELECT sw.*, 
       CONCAT(sw.first_name, ' ', sw.last_name) as full_name,
       DATEDIFF(sw.visa_expiry_date, CURDATE()) as days_to_expiry,
       u.full_name as created_by_name
       FROM sponsored_workers sw
       LEFT JOIN users u ON sw.created_by = u.id
       WHERE sw.id = ? AND sw.business_profile_id = ?");
$stmt->execute([$worker_id, $_SESSION['business_profile_id']]);
$worker = $stmt->fetch();

if (!$worker) {
    header('Location: list.php?error=Worker not found');
    exit;
}

// Get recent attendance
$stmt = $pdo->prepare("SELECT * FROM attendance_records 
                      WHERE worker_id = ? 
                      ORDER BY attendance_date DESC LIMIT 10");
$stmt->execute([$worker_id]);
$recent_attendance = $stmt->fetchAll();

// Get documents
$stmt = $pdo->prepare("SELECT * FROM documents 
                      WHERE worker_id = ? 
                      ORDER BY created_at DESC");
$stmt->execute([$worker_id]);
$documents = $stmt->fetchAll();

// Get holiday requests
$stmt = $pdo->prepare("SELECT * FROM holiday_requests 
                      WHERE worker_id = ? 
                      ORDER BY created_at DESC LIMIT 5");
$stmt->execute([$worker_id]);
$holidays = $stmt->fetchAll();
?>

<div class="row">
    <!-- Main Details -->
    <div class="col-md-8">
        <div class="stat-card">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h4><?= htmlspecialchars($worker['full_name']) ?></h4>
                <div>
                    <a href="edit.php?id=<?= $worker['id'] ?>" class="btn btn-warning btn-sm">
                        <i class="bi bi-pencil"></i> Edit
                    </a>
                    <a href="list.php" class="btn btn-secondary btn-sm">
                        <i class="bi bi-arrow-left"></i> Back
                    </a>
                </div>
            </div>
            
            <div class="row mb-4">
                <div class="col-md-6">
                    <table class="table table-sm">
                        <tr>
                            <td width="40%"><strong>Employee Number:</strong></td>
                            <td><?= htmlspecialchars($worker['employee_number']) ?></td>
                        </tr>
                        <tr>
                            <td><strong>Date of Birth:</strong></td>
                            <td><?= format_date($worker['date_of_birth']) ?></td>
                        </tr>
                        <tr>
                            <td><strong>Gender:</strong></td>
                            <td><?= htmlspecialchars($worker['gender'] ?? '-') ?></td>
                        </tr>
                        <tr>
                            <td><strong>Nationality:</strong></td>
                            <td><?= htmlspecialchars($worker['nationality'] ?? '-') ?></td>
                        </tr>
                        <tr>
                            <td><strong>Email:</strong></td>
                            <td><?= htmlspecialchars($worker['email'] ?? '-') ?></td>
                        </tr>
                        <tr>
                            <td><strong>Phone:</strong></td>
                            <td><?= htmlspecialchars($worker['phone'] ?? '-') ?></td>
                        </tr>
                    </table>
                </div>
                
                <div class="col-md-6">
                    <table class="table table-sm">
                        <tr>
                            <td width="40%"><strong>Job Title:</strong></td>
                            <td><?= htmlspecialchars($worker['job_title'] ?? '-') ?></td>
                        </tr>
                        <tr>
                            <td><strong>Department:</strong></td>
                            <td><?= htmlspecialchars($worker['department'] ?? '-') ?></td>
                        </tr>
                        <tr>
                            <td><strong>Employment Status:</strong></td>
                            <td>
                                <span class="badge <?= $worker['employment_status'] === 'Active' ? 'bg-success' : 'bg-secondary' ?>">
                                    <?= htmlspecialchars($worker['employment_status']) ?>
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td><strong>Contract Type:</strong></td>
                            <td><?= htmlspecialchars($worker['contract_type'] ?? '-') ?></td>
                        </tr>
                        <tr>
                            <td><strong>Start Date:</strong></td>
                            <td><?= format_date($worker['employment_start_date']) ?></td>
                        </tr>
                        <tr>
                            <td><strong>Salary:</strong></td>
                            <td><?= $worker['salary'] ? '£' . number_format($worker['salary'], 2) : '-' ?></td>
                        </tr>
                    </table>
                </div>
            </div>
            
            <hr>
            
            <h6 class="text-primary mb-3">Immigration Information</h6>
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-sm">
                        <tr>
                            <td width="40%"><strong>Visa Type:</strong></td>
                            <td><?= htmlspecialchars($worker['visa_type'] ?? '-') ?></td>
                        </tr>
                        <tr>
                            <td><strong>Visa Number:</strong></td>
                            <td><?= htmlspecialchars($worker['visa_number'] ?? '-') ?></td>
                        </tr>
                        <tr>
                            <td><strong>Visa Issue Date:</strong></td>
                            <td><?= format_date($worker['visa_issue_date']) ?></td>
                        </tr>
                        <tr>
                            <td><strong>Visa Expiry Date:</strong></td>
                            <td>
                                <?= format_date($worker['visa_expiry_date']) ?>
                                <?php if ($worker['days_to_expiry'] !== null): ?>
                                    <?php if ($worker['days_to_expiry'] < 0): ?>
                                        <span class="badge bg-danger">Expired</span>
                                    <?php elseif ($worker['days_to_expiry'] <= 30): ?>
                                        <span class="badge bg-danger"><?= $worker['days_to_expiry'] ?> days left</span>
                                    <?php elseif ($worker['days_to_expiry'] <= 90): ?>
                                        <span class="badge bg-warning"><?= $worker['days_to_expiry'] ?> days left</span>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </td>
                        </tr>
                    </table>
                </div>
                
                <div class="col-md-6">
                    <table class="table table-sm">
                        <tr>
                            <td width="40%"><strong>Passport Number:</strong></td>
                            <td><?= htmlspecialchars($worker['passport_number'] ?? '-') ?></td>
                        </tr>
                        <tr>
                            <td><strong>Passport Expiry:</strong></td>
                            <td><?= format_date($worker['passport_expiry_date']) ?></td>
                        </tr>
                        <tr>
                            <td><strong>CoS Number:</strong></td>
                            <td><?= htmlspecialchars($worker['cos_number'] ?? '-') ?></td>
                        </tr>
                        <tr>
                            <td><strong>CoS Issue Date:</strong></td>
                            <td><?= format_date($worker['cos_issue_date']) ?></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        
        <!-- Recent Attendance -->
        <div class="stat-card mt-3">
            <h6>Recent Attendance</h6>
            <div class="table-responsive">
                <table class="table table-sm table-hover">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Check In</th>
                            <th>Check Out</th>
                            <th>Hours</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($recent_attendance)): ?>
                        <tr>
                            <td colspan="5" class="text-center text-muted">No attendance records</td>
                        </tr>
                        <?php else: ?>
                        <?php foreach ($recent_attendance as $att): ?>
                        <tr>
                            <td><?= format_date($att['attendance_date']) ?></td>
                            <td><?= $att['check_in_time'] ?? '-' ?></td>
                            <td><?= $att['check_out_time'] ?? '-' ?></td>
                            <td><?= $att['hours_worked'] ?? '-' ?></td>
                            <td>
                                <span class="badge <?= $att['status'] === 'Present' ? 'bg-success' : 'bg-secondary' ?>">
                                    <?= htmlspecialchars($att['status']) ?>
                                </span>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    
    <!-- Sidebar -->
    <div class="col-md-4">
        <!-- Quick Actions -->
        <div class="stat-card">
            <h6>Quick Actions</h6>
            <div class="d-grid gap-2">
                <a href="../attendance/mark.php?worker_id=<?= $worker['id'] ?>" class="btn btn-success btn-sm">
                    <i class="bi bi-calendar-check"></i> Mark Attendance
                </a>
                <a href="../documents/upload.php?worker_id=<?= $worker['id'] ?>" class="btn btn-primary btn-sm">
                    <i class="bi bi-file-earmark-arrow-up"></i> Upload Document
                </a>
                <a href="../holidays/request.php?worker_id=<?= $worker['id'] ?>" class="btn btn-warning btn-sm">
                    <i class="bi bi-umbrella"></i> Request Holiday
                </a>
            </div>
        </div>
        
        <!-- Documents -->
        <div class="stat-card mt-3">
            <h6>Documents (<?= count($documents) ?>)</h6>
            <?php if (empty($documents)): ?>
                <p class="text-muted small">No documents uploaded</p>
            <?php else: ?>
                <div class="list-group list-group-flush">
                    <?php foreach (array_slice($documents, 0, 5) as $doc): ?>
                    <a href="../documents/view.php?id=<?= $doc['id'] ?>" class="list-group-item list-group-item-action py-2">
                        <small>
                            <i class="bi bi-file-earmark"></i> 
                            <?= htmlspecialchars($doc['document_name']) ?>
                            <br>
                            <span class="text-muted"><?= $doc['document_category'] ?></span>
                        </small>
                    </a>
                    <?php endforeach; ?>
                </div>
                <?php if (count($documents) > 5): ?>
                <a href="../documents/list.php?worker_id=<?= $worker['id'] ?>" class="btn btn-sm btn-outline-primary w-100 mt-2">
                    View All Documents
                </a>
                <?php endif; ?>
            <?php endif; ?>
        </div>
        
        <!-- Holiday Requests -->
        <div class="stat-card mt-3">
            <h6>Recent Holidays</h6>
            <?php if (empty($holidays)): ?>
                <p class="text-muted small">No holiday requests</p>
            <?php else: ?>
                <?php foreach ($holidays as $holiday): ?>
                <div class="mb-2 p-2 bg-light rounded">
                    <small>
                        <strong><?= format_date($holiday['start_date']) ?> - <?= format_date($holiday['end_date']) ?></strong><br>
                        <?= $holiday['total_days'] ?> days | 
                        <span class="badge <?= $holiday['approval_status'] === 'Approved' ? 'bg-success' : ($holiday['approval_status'] === 'Pending' ? 'bg-warning' : 'bg-danger') ?>">
                            <?= $holiday['approval_status'] ?>
                        </span>
                    </small>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
        
        <!-- Record Info -->
        <div class="stat-card mt-3">
            <h6>Record Information</h6>
            <small>
                <strong>Created:</strong> <?= format_datetime($worker['created_at']) ?><br>
                <strong>By:</strong> <?= htmlspecialchars($worker['created_by_name'] ?? 'System') ?><br>
                <strong>Last Updated:</strong> <?= format_datetime($worker['updated_at']) ?>
            </small>
        </div>
    </div>
</div>

<?php require_once '../../includes/footer.php'; ?>