
/* ============================================================
   FILE 11: modules/workers/delete.php
   Delete worker (soft delete)
   ============================================================ */

<?php
require __DIR__ . '/../../config/database.php';
require __DIR__ . '/../../includes/functions.php';

require_login();
require_permission(70);

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: ' . base_url('modules/workers/list.php'));
    exit;
}

$worker_id = (int)$_POST['worker_id'];
$reason = $_POST['deletion_reason'] ?? 'No reason provided';

try {
    $pdo->beginTransaction();
    
    // Soft delete
    $stmt = $pdo->prepare("UPDATE sponsored_workers SET 
                          deleted_at = NOW(), 
                          deleted_by = ?,
                          deletion_reason = ?,
                          is_active = 0
                          WHERE id = ?");
    $stmt->execute([$user['id'], $reason, $worker_id]);
    
    log_audit($user['id'], 'DELETE', 'sponsored_workers', $worker_id, null, $reason);
    
    $pdo->commit();
    
    $_SESSION['flash']['success'] = 'Worker deleted successfully';
    
} catch (Exception $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    $_SESSION['flash']['error'] = 'Error deleting worker: ' . $e->getMessage();
}

header('Location: ' . base_url('modules/workers/list.php'));
exit;