<?php
$page_title = 'Add New Worker';
require_once '../../includes/header.php';
require_permission(70); // HR Manager or above

$errors = [];
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate required fields
    $required = ['first_name', 'last_name'];
    foreach ($required as $field) {
        if (empty($_POST[$field])) {
            $errors[] = ucwords(str_replace('_', ' ', $field)) . " is required";
        }
    }
    
    if (empty($errors)) {
        try {
            // Generate employee number
            $employee_number = generate_employee_number($pdo);
            
            $stmt = $pdo->prepare("INSERT INTO sponsored_workers 
                (business_profile_id, employee_number, first_name, last_name, date_of_birth, 
                gender, nationality, email, phone, address_line1, address_line2, city, postcode, 
                visa_type, visa_number, visa_issue_date, visa_expiry_date, passport_number, 
                passport_expiry_date, cos_number, job_title, department, employment_status, 
                contract_type, employment_start_date, salary, work_pattern, created_by) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            
            $stmt->execute([
                $_SESSION['business_profile_id'],
                $employee_number,
                $_POST['first_name'],
                $_POST['last_name'],
                $_POST['date_of_birth'] ?: null,
                $_POST['gender'] ?: null,
                $_POST['nationality'] ?: null,
                $_POST['email'] ?: null,
                $_POST['phone'] ?: null,
                $_POST['address_line1'] ?: null,
                $_POST['address_line2'] ?: null,
                $_POST['city'] ?: null,
                $_POST['postcode'] ?: null,
                $_POST['visa_type'] ?: null,
                $_POST['visa_number'] ?: null,
                $_POST['visa_issue_date'] ?: null,
                $_POST['visa_expiry_date'] ?: null,
                $_POST['passport_number'] ?: null,
                $_POST['passport_expiry_date'] ?: null,
                $_POST['cos_number'] ?: null,
                $_POST['job_title'] ?: null,
                $_POST['department'] ?: null,
                $_POST['employment_status'] ?: 'Active',
                $_POST['contract_type'] ?: null,
                $_POST['employment_start_date'] ?: null,
                $_POST['salary'] ?: null,
                $_POST['work_pattern'] ?: null,
                $_SESSION['user_id']
            ]);
            
            $worker_id = $pdo->lastInsertId();
            log_action($pdo, 'Worker Created', 'sponsored_workers', $worker_id);
            
            header('Location: view.php?id=' . $worker_id . '&success=Worker added successfully');
            exit;
            
        } catch (PDOException $e) {
            $errors[] = "Database error: " . $e->getMessage();
        }
    }
}

// Get dropdown options
$visa_types = get_list_items($pdo, 'visa_types');
$employment_statuses = get_list_items($pdo, 'employment_status');
$contract_types = get_list_items($pdo, 'contract_types');
$work_patterns = get_list_items($pdo, 'work_patterns');
$departments = get_list_items($pdo, 'departments');
?>

<?php if (!empty($errors)): ?>
    <div class="alert alert-danger">
        <ul class="mb-0">
            <?php foreach ($errors as $error): ?>
                <li><?= htmlspecialchars($error) ?></li>
            <?php endforeach; ?>
        </ul>
    </div>
<?php endif; ?>

<div class="stat-card">
    <h5><i class="bi bi-person-plus"></i> Add New Worker</h5>
    <hr>
    
    <form method="POST">
        <div class="row">
            <!-- Personal Information -->
            <div class="col-md-6">
                <h6 class="mb-3 text-primary">Personal Information</h6>
                
                <div class="mb-3">
                    <label class="form-label">First Name <span class="text-danger">*</span></label>
                    <input type="text" name="first_name" class="form-control" required 
                           value="<?= htmlspecialchars($_POST['first_name'] ?? '') ?>">
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Last Name <span class="text-danger">*</span></label>
                    <input type="text" name="last_name" class="form-control" required 
                           value="<?= htmlspecialchars($_POST['last_name'] ?? '') ?>">
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Date of Birth</label>
                    <input type="date" name="date_of_birth" class="form-control" 
                           value="<?= htmlspecialchars($_POST['date_of_birth'] ?? '') ?>">
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Gender</label>
                    <select name="gender" class="form-select">
                        <option value="">Select...</option>
                        <option value="Male">Male</option>
                        <option value="Female">Female</option>
                        <option value="Other">Other</option>
                    </select>
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Nationality</label>
                    <input type="text" name="nationality" class="form-control" 
                           value="<?= htmlspecialchars($_POST['nationality'] ?? '') ?>">
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Email</label>
                    <input type="email" name="email" class="form-control" 
                           value="<?= htmlspecialchars($_POST['email'] ?? '') ?>">
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Phone</label>
                    <input type="tel" name="phone" class="form-control" 
                           value="<?= htmlspecialchars($_POST['phone'] ?? '') ?>">
                </div>
            </div>
            
            <!-- Immigration & Employment -->
            <div class="col-md-6">
                <h6 class="mb-3 text-primary">Immigration Information</h6>
                
                <div class="mb-3">
                    <label class="form-label">Visa Type</label>
                    <select name="visa_type" class="form-select">
                        <option value="">Select...</option>
                        <?php foreach ($visa_types as $value => $label): ?>
                            <option value="<?= $value ?>"><?= htmlspecialchars($label) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Visa Number</label>
                    <input type="text" name="visa_number" class="form-control">
                </div>
                
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Visa Issue Date</label>
                        <input type="date" name="visa_issue_date" class="form-control">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Visa Expiry Date</label>
                        <input type="date" name="visa_expiry_date" class="form-control">
                    </div>
                </div>
                
                <div class="mb-3">
                    <label class="form-label">CoS Number</label>
                    <input type="text" name="cos_number" class="form-control">
                </div>
                
                <h6 class="mb-3 text-primary mt-4">Employment Information</h6>
                
                <div class="mb-3">
                    <label class="form-label">Job Title</label>
                    <input type="text" name="job_title" class="form-control">
                </div>
                
                <div class="mb-3">
                    <label class="form-label">Department</label>
                    <select name="department" class="form-select">
                        <option value="">Select...</option>
                        <?php foreach ($departments as $value => $label): ?>
                            <option value="<?= $value ?>"><?= htmlspecialchars($label) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Contract Type</label>
                        <select name="contract_type" class="form-select">
                            <option value="">Select...</option>
                            <?php foreach ($contract_types as $value => $label): ?>
                                <option value="<?= $value ?>"><?= htmlspecialchars($label) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Work Pattern</label>
                        <select name="work_pattern" class="form-select">
                            <option value="">Select...</option>
                            <?php foreach ($work_patterns as $value => $label): ?>
                                <option value="<?= $value ?>"><?= htmlspecialchars($label) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Start Date</label>
                        <input type="date" name="employment_start_date" class="form-control">
                    </div>
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Annual Salary</label>
                        <input type="number" name="salary" class="form-control" step="0.01">
                    </div>
                </div>
            </div>
        </div>
        
        <hr>
        
        <div class="d-flex justify-content-between">
            <a href="list.php" class="btn btn-secondary">
                <i class="bi bi-x-circle"></i> Cancel
            </a>
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-save"></i> Add Worker
            </button>
        </div>
    </form>
</div>

<?php require_once '../../includes/footer.php'; ?>
