<?php
$page_title = 'Upload Document';
require_once '../../includes/header.php';
require_permission(60);

$errors = [];
$worker_id = $_GET['worker_id'] ?? '';

// Get workers
$stmt = $pdo->prepare("SELECT id, CONCAT(first_name, ' ', last_name) as name 
                      FROM sponsored_workers 
                      WHERE is_active = 1 AND business_profile_id = ? 
                      ORDER BY first_name");
$stmt->execute([$_SESSION['business_profile_id']]);
$workers = $stmt->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $worker_id = $_POST['worker_id'] ?: null;
    $category = $_POST['document_category'];
    $issue_date = $_POST['issue_date'] ?: null;
    $expiry_date = $_POST['expiry_date'] ?: null;
    
    if (!isset($_FILES['document']) || $_FILES['document']['error'] !== UPLOAD_ERR_OK) {
        $errors[] = "Please select a file to upload";
    } else {
        $upload_dir = '../../uploads/documents/';
        $result = handle_file_upload($_FILES['document'], $upload_dir, ['pdf', 'jpg', 'jpeg', 'png', 'doc', 'docx']);
        
        if ($result['success']) {
            try {
                $stmt = $pdo->prepare("INSERT INTO documents 
                                      (business_profile_id, worker_id, document_category, 
                                      document_name, file_path, file_type, file_size, 
                                      issue_date, expiry_date, uploaded_by) 
                                      VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt->execute([
                    $_SESSION['business_profile_id'],
                    $worker_id,
                    $category,
                    $_FILES['document']['name'],
                    $result['path'],
                    $_FILES['document']['type'],
                    $_FILES['document']['size'],
                    $issue_date,
                    $expiry_date,
                    $_SESSION['user_id']
                ]);
                
                log_action($pdo, 'Document Uploaded', 'documents', $pdo->lastInsertId());
                header('Location: list.php?success=Document uploaded successfully');
                exit;
                
            } catch (PDOException $e) {
                $errors[] = "Database error: " . $e->getMessage();
            }
        } else {
            $errors[] = $result['error'];
        }
    }
}

$categories = get_list_items($pdo, 'document_categories');
?>

<?php if (!empty($errors)): ?>
    <div class="alert alert-danger">
        <ul class="mb-0">
            <?php foreach ($errors as $error): ?>
                <li><?= htmlspecialchars($error) ?></li>
            <?php endforeach; ?>
        </ul>
    </div>
<?php endif; ?>

<div class="stat-card">
    <h5><i class="bi bi-upload"></i> Upload Document</h5>
    <hr>
    
    <form method="POST" enctype="multipart/form-data">
        <div class="mb-3">
            <label class="form-label">Worker (Optional)</label>
            <select name="worker_id" class="form-select">
                <option value="">General Document (No Worker)</option>
                <?php foreach ($workers as $worker): ?>
                    <option value="<?= $worker['id'] ?>" <?= $worker_id == $worker['id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($worker['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <small class="text-muted">Select if document belongs to specific worker</small>
        </div>
        
        <div class="mb-3">
            <label class="form-label">Document Category <span class="text-danger">*</span></label>
            <select name="document_category" class="form-select" required>
                <option value="">Select category...</option>
                <?php foreach ($categories as $value => $label): ?>
                    <option value="<?= $value ?>"><?= htmlspecialchars($label) ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <div class="mb-3">
            <label class="form-label">Document File <span class="text-danger">*</span></label>
            <input type="file" name="document" class="form-control" required 
                   accept=".pdf,.jpg,.jpeg,.png,.doc,.docx">
            <small class="text-muted">Accepted: PDF, JPG, PNG, DOC, DOCX (Max 10MB)</small>
        </div>
        
        <div class="row">
            <div class="col-md-6 mb-3">
                <label class="form-label">Issue Date</label>
                <input type="date" name="issue_date" class="form-control">
            </div>
            
            <div class="col-md-6 mb-3">
                <label class="form-label">Expiry Date</label>
                <input type="date" name="expiry_date" class="form-control">
            </div>
        </div>
        
        <div class="alert alert-info">
            <i class="bi bi-info-circle"></i> Documents will be securely stored and can be verified by HR managers
        </div>
        
        <hr>
        
        <div class="d-flex justify-content-between">
            <a href="list.php" class="btn btn-secondary">
                <i class="bi bi-x-circle"></i> Cancel
            </a>
            <button type="submit" class="btn btn-primary">
                <i class="bi bi-upload"></i> Upload Document
            </button>
        </div>
    </form>
</div>

<?php require_once '../../includes/footer.php'; ?>