<?php
$page_title = 'Documents';
require_once '../../includes/header.php';

$worker_id = $_GET['worker_id'] ?? '';
$category = $_GET['category'] ?? '';

$where = ["d.business_profile_id = ?"];
$params = [$_SESSION['business_profile_id']];

if ($worker_id) {
    $where[] = "d.worker_id = ?";
    $params[] = $worker_id;
}

if ($category) {
    $where[] = "d.document_category = ?";
    $params[] = $category;
}

$where_clause = implode(' AND ', $where);

// Fetch documents
$sql = "SELECT d.*, 
        CONCAT(sw.first_name, ' ', sw.last_name) as worker_name,
        sw.employee_number,
        u1.full_name as uploaded_by_name,
        u2.full_name as verified_by_name
        FROM documents d
        LEFT JOIN sponsored_workers sw ON d.worker_id = sw.id
        LEFT JOIN users u1 ON d.uploaded_by = u1.id
        LEFT JOIN users u2 ON d.verified_by = u2.id
        WHERE $where_clause
        ORDER BY d.created_at DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$documents = $stmt->fetchAll();

// Get categories
$categories = get_list_items($pdo, 'document_categories');

// Get workers for filter
$stmt = $pdo->prepare("SELECT id, CONCAT(first_name, ' ', last_name) as name 
                      FROM sponsored_workers 
                      WHERE is_active = 1 AND business_profile_id = ? 
                      ORDER BY first_name");
$stmt->execute([$_SESSION['business_profile_id']]);
$workers = $stmt->fetchAll();
?>

<div class="stat-card">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h5><i class="bi bi-file-earmark-text"></i> Documents (<?= count($documents) ?>)</h5>
        <a href="upload.php" class="btn btn-primary">
            <i class="bi bi-upload"></i> Upload Document
        </a>
    </div>
    
    <!-- Filters -->
    <form method="GET" class="row g-3 mb-4">
        <div class="col-md-5">
            <select name="worker_id" class="form-select">
                <option value="">All Workers</option>
                <?php foreach ($workers as $worker): ?>
                    <option value="<?= $worker['id'] ?>" <?= $worker_id == $worker['id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($worker['name']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-5">
            <select name="category" class="form-select">
                <option value="">All Categories</option>
                <?php foreach ($categories as $value => $label): ?>
                    <option value="<?= $value ?>" <?= $category === $value ? 'selected' : '' ?>>
                        <?= htmlspecialchars($label) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-2">
            <button type="submit" class="btn btn-secondary w-100">
                <i class="bi bi-filter"></i> Filter
            </button>
        </div>
    </form>
    
    <!-- Documents Table -->
    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Document Name</th>
                    <th>Category</th>
                    <th>Worker</th>
                    <th>Uploaded</th>
                    <th>Expiry</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($documents)): ?>
                <tr>
                    <td colspan="7" class="text-center py-4 text-muted">
                        <i class="bi bi-inbox" style="font-size: 48px;"></i>
                        <p class="mt-2">No documents found</p>
                    </td>
                </tr>
                <?php else: ?>
                <?php foreach ($documents as $doc): ?>
                <tr>
                    <td>
                        <i class="bi bi-file-earmark-pdf text-danger"></i>
                        <strong><?= htmlspecialchars($doc['document_name']) ?></strong>
                    </td>
                    <td><?= htmlspecialchars($doc['document_category']) ?></td>
                    <td><?= htmlspecialchars($doc['worker_name'] ?? 'General') ?></td>
                    <td>
                        <?= format_date($doc['created_at']) ?><br>
                        <small class="text-muted">by <?= htmlspecialchars($doc['uploaded_by_name']) ?></small>
                    </td>
                    <td>
                        <?php if ($doc['expiry_date']): ?>
                            <?= format_date($doc['expiry_date']) ?>
                            <?php
                            $days_to_expiry = (strtotime($doc['expiry_date']) - time()) / 86400;
                            if ($days_to_expiry < 0): ?>
                                <span class="badge bg-danger">Expired</span>
                            <?php elseif ($days_to_expiry <= 30): ?>
                                <span class="badge bg-warning"><?= round($days_to_expiry) ?> days</span>
                            <?php endif; ?>
                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if ($doc['is_verified']): ?>
                            <span class="badge bg-success" title="Verified by <?= htmlspecialchars($doc['verified_by_name']) ?>">
                                <i class="bi bi-check-circle"></i> Verified
                            </span>
                        <?php else: ?>
                            <span class="badge bg-secondary">Pending</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="view.php?id=<?= $doc['id'] ?>" class="btn btn-sm btn-outline-primary" title="View">
                            <i class="bi bi-eye"></i>
                        </a>
                        <a href="<?= htmlspecialchars($doc['file_path']) ?>" class="btn btn-sm btn-outline-success" 
                           download title="Download">
                            <i class="bi bi-download"></i>
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once '../../includes/footer.php'; ?>