<?php
require_once '../../includes/header.php';
require_permission(60);

$errors = [];
$success_count = 0;
$error_count = 0;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['excel_file'])) {
    
    $file = $_FILES['excel_file'];
    $overwrite = isset($_POST['overwrite']);
    
    if ($file['error'] !== UPLOAD_ERR_OK) {
        $errors[] = "File upload error";
    } else {
        $file_ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        
        if (!in_array($file_ext, ['xls', 'xlsx'])) {
            $errors[] = "Only Excel files (.xls, .xlsx) are allowed";
        } else {
            // Read Excel file (requires PhpSpreadsheet library)
            // For now, we'll use a simple CSV approach
            // You'll need to install: composer require phpoffice/phpspreadsheet
            
            try {
                // Simple CSV-like processing
                // For production, use PhpSpreadsheet library
                
                $handle = fopen($file['tmp_name'], 'r');
                
                // Skip first 2 header rows
                fgetcsv($handle);
                fgetcsv($handle);
                
                $date_headers = fgetcsv($handle); // Row with dates
                $dates = array_slice($date_headers, 4); // Skip first 4 columns
                
                $pdo->beginTransaction();
                
                while (($row = fgetcsv($handle)) !== false) {
                    if (count($row) < 5) continue; // Skip invalid rows
                    
                    $employee_number = $row[0];
                    
                    // Get worker ID
                    $stmt = $pdo->prepare("SELECT id FROM sponsored_workers 
                                          WHERE employee_number = ? 
                                          AND business_profile_id = ?");
                    $stmt->execute([$employee_number, $_SESSION['business_profile_id']]);
                    $worker = $stmt->fetch();
                    
                    if (!$worker) continue;
                    
                    // Process each date column
                    for ($i = 0; $i < count($dates); $i++) {
                        $date_col = $dates[$i];
                        $status = $row[4 + $i] ?? '';
                        
                        if (empty($status)) continue;
                        
                        // Convert d/m/Y to Y-m-d
                        $date_parts = explode('/', $date_col);
                        if (count($date_parts) !== 3) continue;
                        $attendance_date = $date_parts[2] . '-' . $date_parts[1] . '-' . $date_parts[0];
                        
                        // Validate status code
                        $valid_statuses = ['P', 'PL', 'UL', 'FO', 'HO'];
                        $status = strtoupper(trim($status));
                        
                        if (!in_array($status, $valid_statuses)) continue;
                        
                        // Check if exists
                        $stmt = $pdo->prepare("SELECT id FROM attendance_records 
                                              WHERE worker_id = ? AND attendance_date = ?");
                        $stmt->execute([$worker['id'], $attendance_date]);
                        $existing = $stmt->fetch();
                        
                        if ($existing) {
                            if ($overwrite) {
                                // Update
                                $stmt = $pdo->prepare("UPDATE attendance_records 
                                                      SET status = ?, marked_by = ? 
                                                      WHERE id = ?");
                                $stmt->execute([$status, $_SESSION['user_id'], $existing['id']]);
                                $success_count++;
                            }
                        } else {
                            // Insert
                            $stmt = $pdo->prepare("INSERT INTO attendance_records 
                                                  (business_profile_id, worker_id, attendance_date, 
                                                  status, marked_by) 
                                                  VALUES (?, ?, ?, ?, ?)");
                            $stmt->execute([
                                $_SESSION['business_profile_id'],
                                $worker['id'],
                                $attendance_date,
                                $status,
                                $_SESSION['user_id']
                            ]);
                            $success_count++;
                        }
                    }
                }
                
                fclose($handle);
                $pdo->commit();
                
                log_action($pdo, 'Attendance Bulk Import', 'attendance_records', null, null, 
                          ['records' => $success_count]);
                
                header('Location: dashboard.php?success=Successfully imported ' . $success_count . ' attendance records');
                exit;
                
            } catch (Exception $e) {
                $pdo->rollBack();
                $errors[] = "Import failed: " . $e->getMessage();
            }
        }
    }
}

if (!empty($errors)) {
    header('Location: dashboard.php?error=' . implode(', ', $errors));
    exit;
}
?>