<?php
require_once '../../includes/header.php';
require_permission(60);

// Set headers for Excel download
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="attendance_template_' . date('Y-m-d') . '.xls"');
header('Cache-Control: max-age=0');

// Get all active workers
$stmt = $pdo->prepare("SELECT sw.employee_number, 
       CONCAT(sw.first_name, ' ', sw.last_name) as full_name,
       sw.department, sw.job_title
       FROM sponsored_workers sw
       WHERE sw.is_active = 1 AND sw.business_profile_id = ?
       ORDER BY sw.employee_number");
$stmt->execute([$_SESSION['business_profile_id']]);
$workers = $stmt->fetchAll();

// Generate dates for next 31 days
$dates = [];
for ($i = 0; $i < 31; $i++) {
    $dates[] = date('d/m/Y', strtotime("+$i days"));
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
</head>
<body>
    <table border="1">
        <tr style="background-color: #0066cc; color: white; font-weight: bold;">
            <td colspan="4">ATTENDANCE TEMPLATE - <?= htmlspecialchars($_SESSION['business_profile_id']) ?></td>
            <td colspan="<?= count($dates) ?>" align="center">DATES (Use format: P, PL, UL, FO, HO)</td>
        </tr>
        <tr style="background-color: #e6f2ff; font-weight: bold;">
            <td width="120">Employee #</td>
            <td width="200">Full Name</td>
            <td width="120">Department</td>
            <td width="150">Job Title</td>
            <?php foreach ($dates as $date): ?>
            <td width="80" align="center"><?= $date ?></td>
            <?php endforeach; ?>
        </tr>
        
        <?php foreach ($workers as $worker): ?>
        <tr>
            <td><?= htmlspecialchars($worker['employee_number']) ?></td>
            <td><?= htmlspecialchars($worker['full_name']) ?></td>
            <td><?= htmlspecialchars($worker['department']) ?></td>
            <td><?= htmlspecialchars($worker['job_title']) ?></td>
            <?php foreach ($dates as $date): ?>
            <td align="center"></td>
            <?php endforeach; ?>
        </tr>
        <?php endforeach; ?>
        
        <tr style="background-color: #fff3cd;">
            <td colspan="<?= 4 + count($dates) ?>">
                <b>STATUS CODES:</b> P = Present | PL = Paid Leave | UL = Unpaid Leave | FO = Full Day Off | HO = Half Day Off | Leave blank if not working
            </td>
        </tr>
        <tr style="background-color: #f8d7da;">
            <td colspan="<?= 4 + count($dates) ?>">
                <b>IMPORTANT:</b> Do NOT modify Employee #, Name, Department columns. Only fill in date columns with status codes.
            </td>
        </tr>
    </table>
</body>
</html>

