<?php
/**
 * File Verification Handler
 * Checks if a file exists and returns its details
 */

header('Content-Type: application/json');

$file = $_GET['file'] ?? '';

if (empty($file)) {
    echo json_encode(['exists' => false, 'error' => 'No file specified']);
    exit;
}

// Security: Prevent directory traversal
$file = str_replace(['../', '..\\'], '', $file);

// Check if file exists
$fullPath = __DIR__ . '/' . $file;

if (file_exists($fullPath) && is_file($fullPath)) {
    $size = filesize($fullPath);
    $modified = filemtime($fullPath);
    
    echo json_encode([
        'exists' => true,
        'size' => $size,
        'modified' => $modified,
        'path' => $file
    ]);
} else {
    echo json_encode([
        'exists' => false,
        'size' => 0,
        'path' => $file
    ]);
}
