<?php
/**
 * Step 7: Final Installation
 */
?>

<h3 class="mb-4"><i class="bi bi-rocket-takeoff-fill"></i> Ready to Install</h3>

<div class="alert alert-success">
    <i class="bi bi-check-circle-fill"></i> <strong>All Prerequisites Complete!</strong>
    <br><small>All installation requirements have been met. Ready to create database tables and finalize setup.</small>
</div>

<div class="card mb-4">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0"><i class="bi bi-list-check"></i> Installation Summary</h5>
    </div>
    <div class="card-body">
        <table class="table table-sm">
            <tr>
                <th width="30%">License Status:</th>
                <td><span class="badge bg-success">Valid</span></td>
            </tr>
            <tr>
                <th>Company:</th>
                <td><?php echo htmlspecialchars($_SESSION['company_name'] ?? 'Not set'); ?></td>
            </tr>
            <tr>
                <th>Database:</th>
                <td><?php echo htmlspecialchars($_SESSION['db_name'] ?? 'Not set'); ?></td>
            </tr>
            <tr>
                <th>Administrator:</th>
                <td><?php echo htmlspecialchars($_SESSION['admin_username'] ?? 'Not set'); ?> (<?php echo htmlspecialchars($_SESSION['admin_email'] ?? ''); ?>)</td>
            </tr>
            <tr>
                <th>Installation Mode:</th>
                <td><?php echo strtoupper($_SESSION['install_mode'] ?? 'local'); ?></td>
            </tr>
        </table>
    </div>
</div>

<div class="alert alert-warning">
    <i class="bi bi-exclamation-triangle-fill"></i> <strong>Important:</strong>
    <ul class="mb-0 mt-2 small">
        <li>This will create all database tables and system configuration</li>
        <li>The process may take 30-60 seconds to complete</li>
        <li>Do not close this window or navigate away during installation</li>
        <li>After completion, you'll be redirected to the login page</li>
    </ul>
</div>

<form method="POST" action="install.php?step=7">
    <input type="hidden" name="start_installation" value="1">

    <div class="d-grid gap-2">
        <button type="submit" class="btn btn-success btn-lg" id="installBtn">
            <i class="bi bi-rocket-takeoff-fill"></i> Start Installation
        </button>
        <a href="install.php?step=6" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left-circle"></i> Back to Admin Setup
        </a>
    </div>
</form>

<div id="installProgress" class="mt-4" style="display: none;">
    <div class="card">
        <div class="card-body">
            <h5><i class="bi bi-hourglass-split"></i> Installing...</h5>
            <div class="progress" style="height: 30px;">
                <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" style="width: 100%">
                    Creating database tables and configuring system...
                </div>
            </div>
            <p class="mt-3 text-muted small">
                <i class="bi bi-info-circle"></i> This may take up to 60 seconds. Please wait...
            </p>
        </div>
    </div>
</div>

<script>
// Show progress indicator when form is submitted
document.querySelector('form').addEventListener('submit', function() {
    document.getElementById('installBtn').disabled = true;
    document.getElementById('installProgress').style.display = 'block';
    window.scrollTo(0, document.body.scrollHeight);
});
</script>
