<?php
/**
 * Step 4: Administrator Account
 */
?>

<h3 class="mb-4"><i class="bi bi-person-badge-fill"></i> Create Administrator Account</h3>

<div class="alert alert-gradient mb-4">
    <i class="bi bi-shield-lock-fill"></i> <strong>Security Features:</strong>
    <ul class="mb-0 mt-2 small">
        <li>Strong password encryption using bcrypt</li>
        <li>4-digit PIN for sensitive operations (deletions, PIN-protected data)</li>
        <li>Automatic session timeout after 20 minutes</li>
        <li>Complete audit trail of all actions</li>
    </ul>
</div>

<form method="POST" action="install.php?step=6" id="adminForm">
    <div class="mb-4">
        <label for="admin_username" class="form-label">
            <strong>Username</strong> <span class="text-danger">*</span>
        </label>
        <input type="text" class="form-control form-control-lg" id="admin_username" name="admin_username"
               value="<?php echo isset($_SESSION['admin_username']) ? htmlspecialchars($_SESSION['admin_username']) : ''; ?>"
               required minlength="3" maxlength="50">
        <small class="form-text text-muted">3-50 characters, no spaces</small>
    </div>

    <div class="mb-4">
        <label for="admin_email" class="form-label">
            <strong>Email Address</strong> <span class="text-danger">*</span>
        </label>
        <input type="email" class="form-control form-control-lg" id="admin_email" name="admin_email"
               value="<?php echo isset($_SESSION['admin_email']) ? htmlspecialchars($_SESSION['admin_email']) : ''; ?>"
               required>
        <small class="form-text text-muted">Used for password recovery and system notifications</small>
    </div>

    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="admin_password" class="form-label">
                <strong>Password</strong> <span class="text-danger">*</span>
            </label>
            <div class="input-group">
                <input type="password" class="form-control" id="admin_password" name="admin_password"
                       required minlength="8">
                <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                    <i class="bi bi-eye"></i>
                </button>
            </div>
            <div class="form-text">
                <small>
                    <i class="bi bi-check-circle text-success" id="length-check"></i> At least 8 characters<br>
                    <i class="bi bi-circle text-muted" id="upper-check"></i> At least one uppercase letter<br>
                    <i class="bi bi-circle text-muted" id="number-check"></i> At least one number
                </small>
            </div>
        </div>

        <div class="col-md-6 mb-3">
            <label for="confirm_password" class="form-label">
                <strong>Confirm Password</strong> <span class="text-danger">*</span>
            </label>
            <input type="password" class="form-control" id="confirm_password" name="confirm_password"
                   required minlength="8">
            <small class="form-text text-muted" id="match-message"></small>
        </div>
    </div>

    <div class="mb-4">
        <label for="admin_pin" class="form-label">
            <strong>4-Digit Security PIN</strong> <span class="text-danger">*</span>
        </label>
        <input type="password" class="form-control form-control-lg text-center" id="admin_pin" name="admin_pin"
               required pattern="[0-9]{4}" maxlength="4" style="max-width: 200px;">
        <small class="form-text text-muted">Required for sensitive operations like deleting workers or accessing confidential notes</small>
    </div>

    <div class="card border-warning mb-4">
        <div class="card-body">
            <h6 class="text-warning"><i class="bi bi-exclamation-triangle-fill"></i> Important:</h6>
            <ul class="small mb-0">
                <li>This will be the <strong>system administrator</strong> account with full access (Permission Level 100)</li>
                <li>You can create additional users with different permission levels later</li>
                <li><strong>Remember your PIN!</strong> It cannot be recovered and is required for critical operations</li>
            </ul>
        </div>
    </div>

    <div class="d-grid gap-2">
        <button type="submit" class="btn btn-primary btn-lg">
            <i class="bi bi-arrow-right-circle-fill"></i> Continue to Installation
        </button>
        <a href="install.php?step=3" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left-circle"></i> Back to Business Profile
        </a>
    </div>
</form>

<script>
// Password visibility toggle
document.getElementById('togglePassword').addEventListener('click', function() {
    const password = document.getElementById('admin_password');
    const icon = this.querySelector('i');
    if (password.type === 'password') {
        password.type = 'text';
        icon.classList.remove('bi-eye');
        icon.classList.add('bi-eye-slash');
    } else {
        password.type = 'password';
        icon.classList.remove('bi-eye-slash');
        icon.classList.add('bi-eye');
    }
});

// Password strength validation
document.getElementById('admin_password').addEventListener('input', function() {
    const password = this.value;

    // Length check
    const lengthCheck = document.getElementById('length-check');
    if (password.length >= 8) {
        lengthCheck.classList.remove('bi-circle', 'text-muted');
        lengthCheck.classList.add('bi-check-circle', 'text-success');
    } else {
        lengthCheck.classList.remove('bi-check-circle', 'text-success');
        lengthCheck.classList.add('bi-circle', 'text-muted');
    }

    // Uppercase check
    const upperCheck = document.getElementById('upper-check');
    if (/[A-Z]/.test(password)) {
        upperCheck.classList.remove('bi-circle', 'text-muted');
        upperCheck.classList.add('bi-check-circle', 'text-success');
    } else {
        upperCheck.classList.remove('bi-check-circle', 'text-success');
        upperCheck.classList.add('bi-circle', 'text-muted');
    }

    // Number check
    const numberCheck = document.getElementById('number-check');
    if (/[0-9]/.test(password)) {
        numberCheck.classList.remove('bi-circle', 'text-muted');
        numberCheck.classList.add('bi-check-circle', 'text-success');
    } else {
        numberCheck.classList.remove('bi-check-circle', 'text-success');
        numberCheck.classList.add('bi-circle', 'text-muted');
    }
});

// Password match validation
document.getElementById('confirm_password').addEventListener('input', function() {
    const password = document.getElementById('admin_password').value;
    const confirm = this.value;
    const message = document.getElementById('match-message');

    if (confirm === '') {
        message.textContent = '';
    } else if (password === confirm) {
        message.textContent = '✓ Passwords match';
        message.classList.remove('text-danger');
        message.classList.add('text-success');
    } else {
        message.textContent = '✗ Passwords do not match';
        message.classList.remove('text-success');
        message.classList.add('text-danger');
    }
});

// PIN validation
document.getElementById('admin_pin').addEventListener('input', function() {
    this.value = this.value.replace(/[^0-9]/g, '').substring(0, 4);
});
</script>
