<?php
/**
 * Step 3: Business Profile
 */
?>

<h3 class="mb-4"><i class="bi bi-building-fill"></i> Business Profile</h3>

<?php if (isset($_SESSION['db_name'])): ?>
<div class="alert alert-success">
    <i class="bi bi-check-circle-fill"></i> <strong>Database Connected!</strong>
    <br><small>Connected to: <?php echo htmlspecialchars($_SESSION['db_name']); ?></small>
</div>
<?php endif; ?>

<div class="alert alert-info">
    <i class="bi bi-info-circle-fill"></i> This information will be displayed in reports and system settings. You can update it later.
</div>

<!-- Companies House Lookup -->
<div class="card bg-light mb-4">
    <div class="card-body">
        <h6 class="mb-3"><i class="bi bi-search"></i> UK Companies House Lookup (Optional)</h6>
        <p class="small mb-3">Enter your Companies House registration number to auto-fill company details.</p>

        <div class="row">
            <div class="col-md-8">
                <input type="text" class="form-control" id="lookup_number" placeholder="Enter company number (e.g., 12345678) or company name">
            </div>
            <div class="col-md-4">
                <button type="button" class="btn btn-outline-primary w-100" id="lookup_btn">
                    <i class="bi bi-search"></i> Lookup
                </button>
            </div>
        </div>
        <small class="text-muted">Try: 00000006 (M&S), 00445790 (Tesco), or enter any UK company name</small>

        <div id="lookup_message" class="mt-2"></div>
    </div>
</div>

<form method="POST" action="install.php?step=3" enctype="multipart/form-data">
    <div class="row">
        <div class="col-md-8 mb-3">
            <label for="company_name" class="form-label">
                <strong>Company Name</strong> <span class="text-danger">*</span>
            </label>
            <input type="text" class="form-control" id="company_name" name="company_name"
                   value="<?php echo isset($_SESSION['company_name']) ? htmlspecialchars($_SESSION['company_name']) : ''; ?>"
                   required>
        </div>

        <div class="col-md-4 mb-3">
            <label for="company_reg" class="form-label">
                <strong>Registration Number</strong>
            </label>
            <input type="text" class="form-control" id="company_reg" name="company_reg"
                   value="<?php echo isset($_SESSION['company_reg']) ? htmlspecialchars($_SESSION['company_reg']) : ''; ?>">
        </div>
    </div>

    <div class="mb-3">
        <label for="industry" class="form-label">
            <strong>Industry Sector</strong>
        </label>
        <select class="form-select" id="industry" name="industry">
            <option value="">Select industry...</option>
            <?php
            $industries = array('Care & Health', 'Construction', 'Information Technology', 'Hospitality',
                                'Manufacturing', 'Education', 'Finance & Banking', 'Retail', 'Other');
            foreach ($industries as $ind) {
                $selected = (isset($_SESSION['industry']) && $_SESSION['industry'] == $ind) ? 'selected' : '';
                echo "<option value=\"{$ind}\" {$selected}>{$ind}</option>";
            }
            ?>
        </select>
    </div>

    <div class="mb-3">
        <label for="address" class="form-label">
            <strong>Address</strong>
        </label>
        <input type="text" class="form-control" id="address" name="address"
               value="<?php echo isset($_SESSION['address']) ? htmlspecialchars($_SESSION['address']) : ''; ?>">
    </div>

    <div class="row">
        <div class="col-md-8 mb-3">
            <label for="city" class="form-label">
                <strong>City</strong>
            </label>
            <input type="text" class="form-control" id="city" name="city"
                   value="<?php echo isset($_SESSION['city']) ? htmlspecialchars($_SESSION['city']) : ''; ?>">
        </div>

        <div class="col-md-4 mb-3">
            <label for="postcode" class="form-label">
                <strong>Postcode</strong>
            </label>
            <input type="text" class="form-control" id="postcode" name="postcode"
                   value="<?php echo isset($_SESSION['postcode']) ? htmlspecialchars($_SESSION['postcode']) : ''; ?>"
                   placeholder="SW1A 1AA">
        </div>
    </div>

    <div class="row">
        <div class="col-md-6 mb-3">
            <label for="phone" class="form-label">
                <strong>Phone Number</strong>
            </label>
            <input type="tel" class="form-control" id="phone" name="phone"
                   value="<?php echo isset($_SESSION['phone']) ? htmlspecialchars($_SESSION['phone']) : ''; ?>"
                   placeholder="+44 20 1234 5678">
        </div>

        <div class="col-md-6 mb-3">
            <label for="email" class="form-label">
                <strong>Company Email</strong>
            </label>
            <input type="email" class="form-control" id="email" name="email"
                   value="<?php echo isset($_SESSION['email']) ? htmlspecialchars($_SESSION['email']) : ''; ?>"
                   placeholder="info@company.com">
        </div>
    </div>

    <div class="card bg-light mb-4">
        <div class="card-body">
            <h6 class="mb-3"><i class="bi bi-image-fill"></i> Company Logo (Optional)</h6>

            <ul class="nav nav-tabs mb-3" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="upload-tab" data-bs-toggle="tab" data-bs-target="#upload-pane" type="button">
                        <i class="bi bi-upload"></i> Upload File
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="url-tab" data-bs-toggle="tab" data-bs-target="#url-pane" type="button">
                        <i class="bi bi-link-45deg"></i> From URL
                    </button>
                </li>
            </ul>

            <div class="tab-content">
                <!-- Upload Tab -->
                <div class="tab-pane fade show active" id="upload-pane">
                    <input type="file" class="form-control" id="logo_upload" name="logo_upload" accept="image/png,image/jpeg,image/jpg,image/gif">
                    <small class="text-muted">Accepted formats: PNG, JPG, GIF | Max size: 2MB</small>
                    <div id="upload_preview" class="mt-3"></div>
                </div>

                <!-- URL Tab -->
                <div class="tab-pane fade" id="url-pane">
                    <input type="url" class="form-control" id="logo_url" name="logo_url" placeholder="https://example.com/logo.png">
                    <small class="text-muted">Enter direct image URL (e.g., from your website)</small>
                    <button type="button" class="btn btn-sm btn-outline-primary mt-2" id="preview_url_btn">
                        <i class="bi bi-eye"></i> Preview
                    </button>
                    <div id="url_preview" class="mt-3"></div>
                </div>
            </div>
        </div>
    </div>

    <div class="d-grid gap-2">
        <button type="submit" class="btn btn-primary btn-lg">
            <i class="bi bi-arrow-right-circle-fill"></i> Continue to Admin Setup
        </button>
        <a href="install.php?step=2" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left-circle"></i> Back to Database
        </a>
    </div>
</form>

<script>
// Companies House Lookup
document.getElementById('lookup_btn').addEventListener('click', function() {
    const searchTerm = document.getElementById('lookup_number').value.trim();
    const messageDiv = document.getElementById('lookup_message');
    const btn = this;

    if (!searchTerm) {
        messageDiv.innerHTML = '<div class="alert alert-warning alert-sm"><i class="bi bi-exclamation-triangle"></i> Please enter a company number or name</div>';
        return;
    }

    // Show loading
    btn.disabled = true;
    btn.innerHTML = '<i class="bi bi-hourglass-split"></i> Searching...';
    messageDiv.innerHTML = '<div class="alert alert-info alert-sm"><i class="bi bi-hourglass-split"></i> Fetching company data from Companies House...</div>';

    // Make AJAX request
    fetch('install.php?step=3&ajax=lookup', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'company_number=' + encodeURIComponent(searchTerm)
    })
    .then(response => response.json())
    .then(data => {
        console.log('API Response:', data); // Debug log
        if (data.success && data.multiple) {
            // Multiple results - show dropdown
            let html = '<div class="alert alert-info alert-sm">';
            html += '<i class="bi bi-list-ul"></i> <strong>Found ' + data.results.length + ' companies. Select one:</strong><br><br>';
            html += '<select class="form-select" id="company_select" size="5">';
            data.results.forEach((company, index) => {
                html += '<option value="' + company.company_number + '">' +
                        company.company_name + ' (' + company.company_number + ') - ' + company.status +
                        '</option>';
            });
            html += '</select><br>';
            html += '<button type="button" class="btn btn-sm btn-primary mt-2" id="select_company_btn">Select</button>';
            html += '</div>';
            messageDiv.innerHTML = html;

            // Add click handler for select button
            document.getElementById('select_company_btn').addEventListener('click', function() {
                const selectedNumber = document.getElementById('company_select').value;
                if (selectedNumber) {
                    // Fetch full details for selected company
                    fetchCompanyDetails(selectedNumber, messageDiv, btn);
                }
            });

            // Double-click to select
            document.getElementById('company_select').addEventListener('dblclick', function() {
                document.getElementById('select_company_btn').click();
            });
        } else if (data.success) {
            // Single result - populate form
            populateForm(data.data, messageDiv);
        } else {
            messageDiv.innerHTML = '<div class="alert alert-warning alert-sm"><i class="bi bi-exclamation-triangle"></i> ' + data.message + '</div>';
        }
    })
    .catch(error => {
        messageDiv.innerHTML = '<div class="alert alert-danger alert-sm"><i class="bi bi-x-circle"></i> Connection error. Please enter details manually.</div>';
        console.error('Error:', error);
    })
    .finally(() => {
        btn.disabled = false;
        btn.innerHTML = '<i class="bi bi-search"></i> Lookup';
    });
});

// Function to fetch full company details
function fetchCompanyDetails(companyNumber, messageDiv, btn) {
    btn.disabled = true;
    btn.innerHTML = '<i class="bi bi-hourglass-split"></i> Loading...';
    messageDiv.innerHTML = '<div class="alert alert-info alert-sm"><i class="bi bi-hourglass-split"></i> Loading company details...</div>';

    fetch('install.php?step=3&ajax=lookup', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: 'company_number=' + encodeURIComponent(companyNumber)
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            populateForm(data.data, messageDiv);
        } else {
            messageDiv.innerHTML = '<div class="alert alert-warning alert-sm"><i class="bi bi-exclamation-triangle"></i> ' + data.message + '</div>';
        }
    })
    .catch(error => {
        messageDiv.innerHTML = '<div class="alert alert-danger alert-sm"><i class="bi bi-x-circle"></i> Error loading company details</div>';
    })
    .finally(() => {
        btn.disabled = false;
        btn.innerHTML = '<i class="bi bi-search"></i> Lookup';
    });
}

// Function to populate form with company data
function populateForm(data, messageDiv) {
    document.getElementById('company_name').value = data.company_name || '';
    document.getElementById('company_reg').value = data.company_number || '';
    document.getElementById('address').value = data.address || '';
    document.getElementById('city').value = data.city || '';
    document.getElementById('postcode').value = data.postcode || '';

    // Show success message with company details
    messageDiv.innerHTML = '<div class="alert alert-success alert-sm">' +
        '<i class="bi bi-check-circle-fill"></i> <strong>Company Found!</strong><br>' +
        '<small>' + data.company_name + ' | Status: ' + data.status + ' | Type: ' + data.type + '</small>' +
        '</div>';
}

// Allow Enter key to trigger lookup
document.getElementById('lookup_number').addEventListener('keypress', function(e) {
    if (e.key === 'Enter') {
        e.preventDefault();
        document.getElementById('lookup_btn').click();
    }
});

// Logo Upload Preview
document.getElementById('logo_upload').addEventListener('change', function(e) {
    const file = e.target.files[0];
    const previewDiv = document.getElementById('upload_preview');

    if (file) {
        // Check file size (2MB max)
        if (file.size > 2 * 1024 * 1024) {
            previewDiv.innerHTML = '<div class="alert alert-danger alert-sm">File too large. Maximum size is 2MB.</div>';
            e.target.value = '';
            return;
        }

        // Check file type
        if (!file.type.match('image.*')) {
            previewDiv.innerHTML = '<div class="alert alert-danger alert-sm">Please select an image file.</div>';
            e.target.value = '';
            return;
        }

        // Show preview
        const reader = new FileReader();
        reader.onload = function(e) {
            previewDiv.innerHTML = '<div class="text-center"><img src="' + e.target.result + '" class="img-thumbnail" style="max-height: 150px;"><br><small class="text-success"><i class="bi bi-check-circle"></i> Logo ready to upload</small></div>';
        };
        reader.readAsDataURL(file);
    } else {
        previewDiv.innerHTML = '';
    }
});

// Logo URL Preview
document.getElementById('preview_url_btn').addEventListener('click', function() {
    const logoUrl = document.getElementById('logo_url').value.trim();
    const previewDiv = document.getElementById('url_preview');

    if (!logoUrl) {
        previewDiv.innerHTML = '<div class="alert alert-warning alert-sm">Please enter a logo URL</div>';
        return;
    }

    // Validate URL format
    try {
        new URL(logoUrl);
    } catch (e) {
        previewDiv.innerHTML = '<div class="alert alert-danger alert-sm">Invalid URL format</div>';
        return;
    }

    // Show loading
    previewDiv.innerHTML = '<div class="text-center"><div class="spinner-border spinner-border-sm"></div> Loading preview...</div>';

    // Create image to test if URL is valid
    const img = new Image();
    img.onload = function() {
        previewDiv.innerHTML = '<div class="text-center"><img src="' + logoUrl + '" class="img-thumbnail" style="max-height: 150px;"><br><small class="text-success"><i class="bi bi-check-circle"></i> Logo URL is valid</small></div>';
    };
    img.onerror = function() {
        previewDiv.innerHTML = '<div class="alert alert-danger alert-sm"><i class="bi bi-x-circle"></i> Unable to load image from this URL. Please check the URL is correct and publicly accessible.</div>';
    };
    img.src = logoUrl;
});

// Logo URL - Preview on Enter key
document.getElementById('logo_url').addEventListener('keypress', function(e) {
    if (e.key === 'Enter') {
        e.preventDefault();
        document.getElementById('preview_url_btn').click();
    }
});
</script>
