<?php
/**
 * Step 2: Choose Installation Method
 */
?>

<h3 class="mb-4"><i class="bi bi-cloud-download"></i> Choose Installation Method</h3>

<div class="alert alert-info">
    <i class="bi bi-info-circle-fill"></i> <strong>Two Installation Options:</strong>
    Select whether you want to download files from our deployment server or use files already uploaded to your server.
</div>

<div class="row g-4 mb-4">
    <!-- Local Install -->
    <div class="col-md-6">
        <div class="card h-100 border-primary installation-card" style="cursor: pointer;" onclick="selectInstallMode('local')">
            <div class="card-body text-center">
                <i class="bi bi-hdd-fill text-primary" style="font-size: 60px;"></i>
                <h5 class="mt-3">Local Install</h5>
                <p class="text-muted small mb-3">Files are already on this server</p>
                <ul class="list-unstyled text-start small">
                    <li><i class="bi bi-check2 text-success"></i> Faster installation</li>
                    <li><i class="bi bi-check2 text-success"></i> No internet download needed</li>
                    <li><i class="bi bi-check2 text-success"></i> Manual file upload via FTP</li>
                    <li><i class="bi bi-info-circle text-muted"></i> Requires technical knowledge</li>
                </ul>
            </div>
            <div class="card-footer bg-primary text-white text-center">
                <strong>Advanced Users</strong>
            </div>
        </div>
    </div>

    <!-- Remote Install -->
    <div class="col-md-6">
        <div class="card h-100 border-success installation-card" style="cursor: pointer;" onclick="selectInstallMode('remote')">
            <div class="card-body text-center">
                <i class="bi bi-cloud-arrow-down-fill text-success" style="font-size: 60px;"></i>
                <h5 class="mt-3">Remote Install <span class="badge bg-success">Recommended</span></h5>
                <p class="text-muted small mb-3">Download files from our server</p>
                <ul class="list-unstyled text-start small">
                    <li><i class="bi bi-check2 text-success"></i> Fully automated</li>
                    <li><i class="bi bi-check2 text-success"></i> Always latest version</li>
                    <li><i class="bi bi-check2 text-success"></i> No manual file upload</li>
                    <li><i class="bi bi-check2 text-success"></i> Easy for non-technical users</li>
                </ul>
            </div>
            <div class="card-footer bg-success text-white text-center">
                <strong>Easiest Method</strong>
            </div>
        </div>
    </div>
</div>

<div class="d-grid gap-2">
    <button type="button" class="btn btn-primary btn-lg" id="continue_btn" disabled onclick="continueToNextStep()">
        <i class="bi bi-arrow-right-circle-fill"></i> Continue to File Operations
    </button>
    <a href="install.php?step=1" class="btn btn-outline-secondary">
        <i class="bi bi-arrow-left-circle"></i> Back to License Validation
    </a>
</div>

<script>
let selectedMode = '';

function selectInstallMode(mode) {
    selectedMode = mode;
    document.getElementById('continue_btn').disabled = false;

    // Visual feedback - remove selection from all cards
    document.querySelectorAll('.installation-card').forEach(card => {
        card.classList.remove('border-3', 'shadow-lg');
        card.style.transform = '';
    });

    // Highlight selected card
    event.currentTarget.classList.add('border-3', 'shadow-lg');
    event.currentTarget.style.transform = 'scale(1.02)';
}

function continueToNextStep() {
    if (!selectedMode) {
        alert('Please select an installation method first');
        return;
    }

    // Save install mode to session via AJAX, then redirect to Step 2.5
    fetch('install.php?action=set_install_mode', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: 'install_mode=' + selectedMode
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Redirect to Step 3 (File Operations)
            window.location.href = 'install.php?step=3';
        } else {
            alert('Error saving installation mode');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        // Fallback: redirect anyway
        window.location.href = 'install.php?step=3';
    });
}
</script>

<style>
.installation-card {
    transition: all 0.3s ease;
}

.installation-card:hover {
    transform: scale(1.05);
    box-shadow: 0 4px 8px rgba(0,0,0,0.2);
}
</style>
