<?php
/**
 * Step 0: Welcome Screen
 */

// System requirements check
$requirements = array(
    'PHP Version 7.4+' => array(
        'status' => version_compare(PHP_VERSION, '7.4.0', '>='),
        'current' => PHP_VERSION,
        'required' => '7.4.0+'
    ),
    'MySQL/MySQLi Extension' => array(
        'status' => extension_loaded('mysqli'),
        'current' => extension_loaded('mysqli') ? 'Installed' : 'Not installed',
        'required' => 'Required'
    ),
    'JSON Extension' => array(
        'status' => extension_loaded('json'),
        'current' => extension_loaded('json') ? 'Installed' : 'Not installed',
        'required' => 'Required'
    ),
    'cURL Extension' => array(
        'status' => function_exists('curl_init'),
        'current' => function_exists('curl_init') ? 'Installed' : 'Not installed (file_get_contents will be used)',
        'required' => 'Recommended'
    ),
    'File Uploads Enabled' => array(
        'status' => ini_get('file_uploads'),
        'current' => ini_get('file_uploads') ? 'Enabled' : 'Disabled',
        'required' => 'Required'
    ),
    'Config Directory Writable' => array(
        'status' => is_writable('config'),
        'current' => is_writable('config') ? 'Writable' : 'Not writable',
        'required' => 'Required'
    ),
    'Uploads Directory Writable' => array(
        'status' => is_writable('uploads'),
        'current' => is_writable('uploads') ? 'Writable' : 'Not writable',
        'required' => 'Required'
    )
);

$all_critical_passed = true;
$warnings = 0;

foreach ($requirements as $name => $req) {
    if (!$req['status']) {
        if ($name !== 'cURL Extension') {
            $all_critical_passed = false;
        } else {
            $warnings++;
        }
    }
}
?>

<div class="text-center mb-5">
    <i class="bi bi-rocket-takeoff-fill" style="font-size: 80px; color: #667eea;"></i>
    <h2 class="mt-4 mb-3">Welcome to SCMS v3.0!</h2>
    <p class="text-muted lead">UK Home Office Sponsorship Compliance Management System</p>
</div>

<?php if ($is_installed): ?>
<div class="alert alert-warning">
    <i class="bi bi-exclamation-triangle-fill"></i> <strong>Installation Detected!</strong><br>
    SCMS appears to already be installed. If you want to reinstall, please use the form below.
</div>

<div class="card border-danger mb-4">
    <div class="card-header bg-danger text-white">
        <i class="bi bi-trash-fill"></i> <strong>Reinstall SCMS</strong>
    </div>
    <div class="card-body">
        <p class="text-danger"><strong>WARNING:</strong> This will permanently delete all data including workers, attendance records, documents, and settings.</p>
        <form method="POST" action="install.php?action=reinstall">
            <div class="alert alert-warning">
                <i class="bi bi-shield-lock-fill"></i> <strong>License Required:</strong> You must provide a valid license key to reinstall for security reasons.
            </div>

            <div class="mb-3">
                <label class="form-label"><strong>License Key</strong> <span class="text-danger">*</span></label>
                <input type="text" name="license_key" class="form-control" placeholder="XXXX-XXXX-XXXX-XXXX" required>
            </div>

            <?php
            // Use the extract_root_domain function from install.php
            $root_domain = extract_root_domain($_SERVER['HTTP_HOST']);
            ?>
            <div class="mb-3">
                <label class="form-label"><strong>License Domain</strong></label>
                <input type="text" name="domain" class="form-control" value="<?php echo htmlspecialchars($root_domain); ?>" readonly style="background-color: #e9ecef; cursor: not-allowed;">
                <small class="form-text text-muted">
                    <i class="bi bi-lock-fill"></i> Root domain - Works on any subdomain/subfolder
                </small>
            </div>

            <div class="mb-3">
                <label class="form-label"><strong>Validator URL</strong></label>
                <input type="url" name="validator_url" class="form-control" value="https://www.expremit.com/lic/api/validate.php">
            </div>

            <hr>

            <div class="mb-3">
                <label class="form-label"><strong>Type DELETE to confirm:</strong> <span class="text-danger">*</span></label>
                <input type="text" name="confirm_delete" class="form-control form-control-lg" placeholder="Type DELETE here" required>
                <small class="text-muted">Must type exactly: <code>DELETE</code> (all caps)</small>
            </div>

            <div class="d-grid gap-2">
                <button type="submit" class="btn btn-danger btn-lg" onclick="return confirm('⚠️ WARNING: This will PERMANENTLY delete ALL data!\n\n✓ All workers\n✓ All attendance records\n✓ All documents\n✓ All settings\n\nThis action CANNOT be undone!\n\nAre you ABSOLUTELY sure?');">
                    <i class="bi bi-trash-fill"></i> Delete Everything & Reinstall
                </button>
            </div>
        </form>
    </div>
</div>

<div class="text-center mt-4">
    <p class="text-muted mb-2">
        <i class="bi bi-info-circle"></i> Came here by mistake?
    </p>
    <a href="admin/login.php" class="btn btn-outline-primary">
        <i class="bi bi-arrow-left-circle"></i> Back to Login Page
    </a>
</div>
<?php else: ?>

<div class="alert alert-gradient mb-4">
    <h5 class="mb-3"><i class="bi bi-star-fill"></i> What is SCMS?</h5>
    <p class="mb-0">
        SCMS is a comprehensive compliance management system built specifically for UK organizations that sponsor foreign workers.
        This installer will guide you through a simple 5-step setup process.
    </p>
</div>

<h4 class="mb-4"><i class="bi bi-clipboard-check"></i> System Requirements Check</h4>

<?php foreach ($requirements as $name => $req): ?>
<div class="requirement <?php echo !$req['status'] ? 'error' : ''; ?>">
    <i class="bi <?php echo $req['status'] ? 'bi-check-circle-fill text-success' : 'bi-x-circle-fill text-danger'; ?>"></i>
    <strong><?php echo $name; ?>:</strong>
    <span class="float-end">
        <small class="text-muted"><?php echo $req['required']; ?></small> |
        <span class="<?php echo $req['status'] ? 'text-success' : 'text-danger'; ?>">
            <?php echo $req['current']; ?>
        </span>
    </span>
</div>
<?php endforeach; ?>

<?php if ($warnings > 0): ?>
<div class="alert alert-warning mt-4">
    <i class="bi bi-info-circle-fill"></i> <strong>Note:</strong> Some recommended features are missing but installation can proceed.
</div>
<?php endif; ?>

<div class="mt-5">
    <h5 class="mb-3"><i class="bi bi-list-stars"></i> Features Included:</h5>
    <div class="row g-3">
        <div class="col-md-6">
            <ul class="list-unstyled">
                <li><i class="bi bi-check2 text-success"></i> Worker Management</li>
                <li><i class="bi bi-check2 text-success"></i> Attendance Tracking (Timegate-style)</li>
                <li><i class="bi bi-check2 text-success"></i> Holiday Management</li>
                <li><i class="bi bi-check2 text-success"></i> Document Management</li>
                <li><i class="bi bi-check2 text-success"></i> Visa Expiry Alerts</li>
                <li><i class="bi bi-check2 text-success"></i> Location Management</li>
            </ul>
        </div>
        <div class="col-md-6">
            <ul class="list-unstyled">
                <li><i class="bi bi-check2 text-success"></i> CoS Management</li>
                <li><i class="bi bi-check2 text-success"></i> Home Office Reporting</li>
                <li><i class="bi bi-check2 text-success"></i> Right to Work Checks</li>
                <li><i class="bi bi-check2 text-success"></i> Advanced Reports (Excel/PDF)</li>
                <li><i class="bi bi-check2 text-success"></i> Audit Trail</li>
                <li><i class="bi bi-check2 text-success"></i> Module System</li>
            </ul>
        </div>
    </div>
</div>

<div class="d-grid gap-2 mt-4">
    <?php if ($all_critical_passed): ?>
        <a href="install.php?step=1" class="btn btn-primary btn-lg">
            <i class="bi bi-arrow-right-circle-fill"></i> Continue to Installation
        </a>
    <?php else: ?>
        <button class="btn btn-danger btn-lg" disabled>
            <i class="bi bi-exclamation-triangle-fill"></i> Please Fix Critical Requirements First
        </button>
        <a href="install.php?step=0" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-clockwise"></i> Recheck Requirements
        </a>
    <?php endif; ?>
</div>

<?php endif; ?>
