<?php
/**
 * Step 2: Database Configuration
 */
?>

<h3 class="mb-4"><i class="bi bi-database-fill"></i> Database Configuration</h3>

<div class="alert alert-info">
    <strong>Note:</strong> Please ensure you have created a MySQL database and have the connection details ready.
</div>

<form method="POST" action="?step=2">
    <div class="mb-3">
        <label for="db_host" class="form-label">Database Host</label>
        <input type="text" class="form-control" id="db_host" name="db_host"
               value="<?php echo $_SESSION['db_host'] ?? 'localhost'; ?>" required>
        <small class="form-text text-muted">Usually "localhost" for most servers</small>
    </div>

    <div class="mb-3">
        <label for="db_name" class="form-label">Database Name *</label>
        <input type="text" class="form-control" id="db_name" name="db_name"
               value="<?php echo $_SESSION['db_name'] ?? ''; ?>" required>
        <small class="form-text text-muted">The name of your MySQL database</small>
    </div>

    <div class="mb-3">
        <label for="db_user" class="form-label">Database Username *</label>
        <input type="text" class="form-control" id="db_user" name="db_user"
               value="<?php echo $_SESSION['db_user'] ?? ''; ?>" required>
    </div>

    <div class="mb-3">
        <label for="db_pass" class="form-label">Database Password</label>
        <input type="password" class="form-control" id="db_pass" name="db_pass"
               value="<?php echo $_SESSION['db_pass'] ?? ''; ?>">
        <small class="form-text text-muted">Leave blank if no password is set</small>
    </div>

    <div class="mb-3">
        <label for="db_prefix" class="form-label">Table Prefix</label>
        <input type="text" class="form-control" id="db_prefix" name="db_prefix"
               value="<?php echo $_SESSION['db_prefix'] ?? 'scms_'; ?>">
        <small class="form-text text-muted">Prefix for all database tables (default: scms_)</small>
    </div>

    <div class="d-grid gap-2">
        <button type="submit" name="test_connection" class="btn btn-outline-primary">
            <i class="bi bi-plug-fill"></i> Test Connection
        </button>
        <button type="submit" class="btn btn-primary">
            <i class="bi bi-arrow-right-circle"></i> Save & Continue
        </button>
        <a href="?step=1" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-left-circle"></i> Back
        </a>
    </div>
</form>

<div class="mt-4">
    <h6>Need Help?</h6>
    <ul class="small">
        <li><strong>Shared Hosting:</strong> Check your hosting control panel (cPanel) for database details</li>
        <li><strong>Local Development:</strong> Use "root" as username, leave password blank</li>
        <li><strong>VPS/Cloud:</strong> Use the credentials you set during MySQL installation</li>
    </ul>
</div>
