<?php
/**
 * Step 1: Welcome & System Requirements Check
 */

// Check system requirements
$requirements = [
    'PHP Version' => [
        'required' => '7.4.0',
        'current' => PHP_VERSION,
        'status' => version_compare(PHP_VERSION, '7.4.0', '>=')
    ],
    'MySQL Extension' => [
        'required' => 'mysqli',
        'current' => extension_loaded('mysqli') ? 'Installed' : 'Not installed',
        'status' => extension_loaded('mysqli')
    ],
    'JSON Extension' => [
        'required' => 'json',
        'current' => extension_loaded('json') ? 'Installed' : 'Not installed',
        'status' => extension_loaded('json')
    ],
    'File Uploads' => [
        'required' => 'Enabled',
        'current' => ini_get('file_uploads') ? 'Enabled' : 'Disabled',
        'status' => ini_get('file_uploads')
    ],
    'Config Directory Writable' => [
        'required' => 'Yes',
        'current' => is_writable('../config') ? 'Yes' : 'No',
        'status' => is_writable('../config')
    ],
    'Uploads Directory Writable' => [
        'required' => 'Yes',
        'current' => is_writable('../uploads') ? 'Yes' : 'No',
        'status' => is_writable('../uploads')
    ]
];

$all_passed = true;
foreach ($requirements as $req) {
    if (!$req['status']) {
        $all_passed = false;
        break;
    }
}
?>

<div class="text-center mb-4">
    <i class="bi bi-rocket-takeoff" style="font-size: 60px; color: #667eea;"></i>
    <h2 class="mt-3">Welcome to SCMS v3.0!</h2>
    <p class="text-muted">UK Home Office Sponsorship Compliance Management System</p>
</div>

<div class="alert alert-info">
    <h5><i class="bi bi-info-circle-fill"></i> About SCMS</h5>
    <p class="mb-0">
        SCMS v3.0 is a comprehensive compliance management system designed specifically for UK organizations
        that sponsor foreign workers. This installer will guide you through setting up your system in just 5 easy steps.
    </p>
</div>

<h4 class="mb-3">System Requirements Check</h4>

<?php foreach ($requirements as $name => $req): ?>
<div class="requirement <?php echo !$req['status'] ? 'error' : ''; ?>">
    <i class="bi <?php echo $req['status'] ? 'bi-check-circle-fill text-success' : 'bi-x-circle-fill text-danger'; ?>"></i>
    <strong><?php echo $name; ?>:</strong>
    <span class="float-end">
        <span class="text-muted">Required: <?php echo $req['required']; ?></span> |
        <span class="<?php echo $req['status'] ? 'text-success' : 'text-danger'; ?>">
            Current: <?php echo $req['current']; ?>
        </span>
    </span>
</div>
<?php endforeach; ?>

<div class="mt-4">
    <h5>Features Included:</h5>
    <div class="row">
        <div class="col-md-6">
            <ul>
                <li>Worker Management</li>
                <li>Attendance Tracking</li>
                <li>Holiday Management</li>
                <li>Document Management</li>
                <li>Visa Expiry Alerts</li>
            </ul>
        </div>
        <div class="col-md-6">
            <ul>
                <li>CoS Management</li>
                <li>Home Office Reporting</li>
                <li>RTW Checks</li>
                <li>Advanced Reports</li>
                <li>Module System</li>
            </ul>
        </div>
    </div>
</div>

<div class="d-grid gap-2 mt-4">
    <?php if ($all_passed): ?>
        <a href="?step=2" class="btn btn-primary btn-lg">
            <i class="bi bi-arrow-right-circle"></i> Continue to Database Setup
        </a>
    <?php else: ?>
        <button class="btn btn-danger btn-lg" disabled>
            <i class="bi bi-exclamation-triangle"></i> Please Fix Requirements First
        </button>
        <a href="?step=1" class="btn btn-outline-secondary">
            <i class="bi bi-arrow-clockwise"></i> Recheck Requirements
        </a>
    <?php endif; ?>
</div>
