<?php
/**
 * SCMS v3.0 - WordPress-Style Installer
 * 5-Step Installation Process
 */

session_start();

// Check if already installed
if (file_exists('../config/database.php') && !isset($_GET['reinstall'])) {
    require_once '../config/database.php';
    if (defined('DB_NAME')) {
        header('Location: ../index.php');
        exit;
    }
}

$step = isset($_GET['step']) ? (int)$_GET['step'] : 1;
$error = '';
$success = '';

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    switch ($step) {
        case 2:
            // Database configuration
            $_SESSION['db_host'] = $_POST['db_host'] ?? 'localhost';
            $_SESSION['db_name'] = $_POST['db_name'] ?? '';
            $_SESSION['db_user'] = $_POST['db_user'] ?? '';
            $_SESSION['db_pass'] = $_POST['db_pass'] ?? '';
            $_SESSION['db_prefix'] = $_POST['db_prefix'] ?? 'scms_';

            // Test connection
            if (isset($_POST['test_connection'])) {
                $conn = @mysqli_connect($_SESSION['db_host'], $_SESSION['db_user'], $_SESSION['db_pass'], $_SESSION['db_name']);
                if ($conn) {
                    $success = 'Database connection successful!';
                    mysqli_close($conn);
                } else {
                    $error = 'Connection failed: ' . mysqli_connect_error();
                }
            } else {
                // Validate and move to next step
                if (empty($_SESSION['db_name']) || empty($_SESSION['db_user'])) {
                    $error = 'Please fill in all required fields';
                } else {
                    header('Location: ?step=3');
                    exit;
                }
            }
            break;

        case 3:
            // Business profile
            $_SESSION['company_name'] = $_POST['company_name'] ?? '';
            $_SESSION['company_reg'] = $_POST['company_reg'] ?? '';
            $_SESSION['industry'] = $_POST['industry'] ?? '';
            $_SESSION['address'] = $_POST['address'] ?? '';
            $_SESSION['city'] = $_POST['city'] ?? '';
            $_SESSION['postcode'] = $_POST['postcode'] ?? '';
            $_SESSION['phone'] = $_POST['phone'] ?? '';
            $_SESSION['email'] = $_POST['email'] ?? '';

            if (empty($_SESSION['company_name'])) {
                $error = 'Company name is required';
            } else {
                header('Location: ?step=4');
                exit;
            }
            break;

        case 4:
            // Administrator account
            $_SESSION['admin_username'] = $_POST['admin_username'] ?? '';
            $_SESSION['admin_email'] = $_POST['admin_email'] ?? '';
            $_SESSION['admin_password'] = $_POST['admin_password'] ?? '';
            $_SESSION['admin_pin'] = $_POST['admin_pin'] ?? '';
            $confirm_password = $_POST['confirm_password'] ?? '';

            if (empty($_SESSION['admin_username']) || empty($_SESSION['admin_email']) || empty($_SESSION['admin_password'])) {
                $error = 'All fields are required';
            } elseif ($_SESSION['admin_password'] !== $confirm_password) {
                $error = 'Passwords do not match';
            } elseif (strlen($_SESSION['admin_password']) < 8) {
                $error = 'Password must be at least 8 characters';
            } elseif (strlen($_SESSION['admin_pin']) !== 4 || !ctype_digit($_SESSION['admin_pin'])) {
                $error = 'PIN must be exactly 4 digits';
            } else {
                header('Location: ?step=5');
                exit;
            }
            break;
    }
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SCMS v3.0 Installer - Step <?php echo $step; ?> of 5</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; }
        .installer-container { max-width: 800px; margin: 50px auto; }
        .installer-card { background: white; border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.2); overflow: hidden; }
        .installer-header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px; text-align: center; }
        .installer-body { padding: 40px; }
        .step-indicator { display: flex; justify-content: space-between; margin-bottom: 30px; }
        .step { flex: 1; text-align: center; position: relative; padding: 10px; }
        .step:before { content: ''; position: absolute; top: 20px; left: 0; right: 0; height: 2px; background: #e0e0e0; z-index: 0; }
        .step:first-child:before { left: 50%; }
        .step:last-child:before { right: 50%; }
        .step-number { width: 40px; height: 40px; border-radius: 50%; background: #e0e0e0; color: #666; display: inline-flex; align-items: center; justify-content: center; font-weight: bold; position: relative; z-index: 1; margin-bottom: 5px; }
        .step.active .step-number { background: #667eea; color: white; }
        .step.completed .step-number { background: #28a745; color: white; }
        .requirement { padding: 10px; border-left: 3px solid #28a745; background: #f8f9fa; margin-bottom: 10px; }
        .requirement.error { border-color: #dc3545; }
        .requirement i { margin-right: 10px; }
    </style>
</head>
<body>
    <div class="installer-container">
        <div class="installer-card">
            <div class="installer-header">
                <h1><i class="bi bi-gear-fill"></i> SCMS v3.0 Installer</h1>
                <p class="mb-0">Sponsorship Compliance Management System</p>
            </div>

            <div class="installer-body">
                <!-- Step Indicator -->
                <div class="step-indicator">
                    <div class="step <?php echo $step >= 1 ? 'completed' : ''; ?> <?php echo $step == 1 ? 'active' : ''; ?>">
                        <div class="step-number">1</div>
                        <small>Welcome</small>
                    </div>
                    <div class="step <?php echo $step >= 2 ? 'completed' : ''; ?> <?php echo $step == 2 ? 'active' : ''; ?>">
                        <div class="step-number">2</div>
                        <small>Database</small>
                    </div>
                    <div class="step <?php echo $step >= 3 ? 'completed' : ''; ?> <?php echo $step == 3 ? 'active' : ''; ?>">
                        <div class="step-number">3</div>
                        <small>Business</small>
                    </div>
                    <div class="step <?php echo $step >= 4 ? 'completed' : ''; ?> <?php echo $step == 4 ? 'active' : ''; ?>">
                        <div class="step-number">4</div>
                        <small>Admin</small>
                    </div>
                    <div class="step <?php echo $step >= 5 ? 'completed' : ''; ?> <?php echo $step == 5 ? 'active' : ''; ?>">
                        <div class="step-number">5</div>
                        <small>Install</small>
                    </div>
                </div>

                <?php if ($error): ?>
                <div class="alert alert-danger">
                    <i class="bi bi-exclamation-triangle-fill"></i> <?php echo htmlspecialchars($error); ?>
                </div>
                <?php endif; ?>

                <?php if ($success): ?>
                <div class="alert alert-success">
                    <i class="bi bi-check-circle-fill"></i> <?php echo htmlspecialchars($success); ?>
                </div>
                <?php endif; ?>

                <!-- Step Content -->
                <?php include "step{$step}.php"; ?>
            </div>
        </div>

        <div class="text-center mt-3">
            <small class="text-white">SCMS v3.0 &copy; 2025 | <a href="mailto:abz@yours.com" class="text-white">Support: Mr Awan</a></small>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
