<?php
/**
 * SCMS v3.0 - Main Entry Point
 * Redirects to appropriate page based on auth status
 */

session_start();

// Check if system is installed
if (!file_exists('config/database.php')) {
    // Not installed - redirect to installer
    header('Location: install.php');
    exit;
}

// Check if user is logged in
if (isset($_SESSION['user_id']) && !empty($_SESSION['user_id'])) {
    // User is authenticated - redirect to dashboard
    header('Location: admin/dashboard.php');
    exit;
} else {
    // User is not authenticated - redirect to login
    header('Location: admin/login.php');
    exit;
}
