<?php
session_start();
?>
<!DOCTYPE html>
<html>
<head>
    <title>Session Debug</title>
    <style>
        body { font-family: monospace; padding: 20px; }
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #4CAF50; color: white; }
        .set { color: green; font-weight: bold; }
        .notset { color: red; }
    </style>
</head>
<body>
    <h1>Session Debug - SCMS Installer</h1>
    <p><strong>Session ID:</strong> <?php echo session_id(); ?></p>
    <p><strong>Session Status:</strong> <?php echo session_status() === PHP_SESSION_ACTIVE ? 'ACTIVE' : 'INACTIVE'; ?></p>

    <h2>Required Session Variables:</h2>
    <table>
        <tr>
            <th>Variable</th>
            <th>Status</th>
            <th>Value</th>
        </tr>
        <tr>
            <td>license_key</td>
            <td class="<?php echo isset($_SESSION['license_key']) ? 'set' : 'notset'; ?>">
                <?php echo isset($_SESSION['license_key']) ? 'SET' : 'NOT SET'; ?>
            </td>
            <td><?php echo isset($_SESSION['license_key']) ? htmlspecialchars($_SESSION['license_key']) : '-'; ?></td>
        </tr>
        <tr>
            <td>domain</td>
            <td class="<?php echo isset($_SESSION['domain']) ? 'set' : 'notset'; ?>">
                <?php echo isset($_SESSION['domain']) ? 'SET' : 'NOT SET'; ?>
            </td>
            <td><?php echo isset($_SESSION['domain']) ? htmlspecialchars($_SESSION['domain']) : '-'; ?></td>
        </tr>
        <tr>
            <td>install_max_step</td>
            <td class="<?php echo isset($_SESSION['install_max_step']) ? 'set' : 'notset'; ?>">
                <?php echo isset($_SESSION['install_max_step']) ? 'SET' : 'NOT SET'; ?>
            </td>
            <td><?php echo isset($_SESSION['install_max_step']) ? $_SESSION['install_max_step'] : '-'; ?></td>
        </tr>
        <tr>
            <td>install_mode</td>
            <td class="<?php echo isset($_SESSION['install_mode']) ? 'set' : 'notset'; ?>">
                <?php echo isset($_SESSION['install_mode']) ? 'SET' : 'NOT SET'; ?>
            </td>
            <td><?php echo isset($_SESSION['install_mode']) ? htmlspecialchars($_SESSION['install_mode']) : '-'; ?></td>
        </tr>
        <tr>
            <td>db_host</td>
            <td class="<?php echo isset($_SESSION['db_host']) ? 'set' : 'notset'; ?>">
                <?php echo isset($_SESSION['db_host']) ? 'SET' : 'NOT SET'; ?>
            </td>
            <td><?php echo isset($_SESSION['db_host']) ? htmlspecialchars($_SESSION['db_host']) : '-'; ?></td>
        </tr>
        <tr>
            <td>db_name</td>
            <td class="<?php echo isset($_SESSION['db_name']) ? 'set' : 'notset'; ?>">
                <?php echo isset($_SESSION['db_name']) ? 'SET' : 'NOT SET'; ?>
            </td>
            <td><?php echo isset($_SESSION['db_name']) ? htmlspecialchars($_SESSION['db_name']) : '-'; ?></td>
        </tr>
    </table>

    <h2>All Session Data:</h2>
    <pre><?php print_r($_SESSION); ?></pre>

    <p><a href="install.php">← Back to Installer</a></p>
</body>
</html>
