<?php
/**
 * Debug Install.php - Catch all errors
 */
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/install_debug.log');

// Start output buffering to catch any errors
ob_start();

try {
    echo "<h1>Debug Mode - Loading install.php</h1>\n";
    echo "<pre>\n";
    echo "Step: " . ($_GET['step'] ?? '0') . "\n";
    echo "Session started...\n";
    session_start();
    echo "Session ID: " . session_id() . "\n";
    echo "HTTP_HOST: " . ($_SERVER['HTTP_HOST'] ?? 'NOT SET') . "\n";
    echo "REQUEST_METHOD: " . ($_SERVER['REQUEST_METHOD'] ?? 'NOT SET') . "\n";
    echo "</pre>\n";

    echo "<p><strong>Attempting to include install.php...</strong></p>\n";

    // Include the actual install.php
    include_once 'install.php';

    echo "<p><strong style='color: green;'>✓ Install.php loaded successfully!</strong></p>\n";

} catch (Exception $e) {
    echo "<div style='background: #ffeeee; border: 2px solid red; padding: 20px; margin: 20px;'>";
    echo "<h2>Exception Caught:</h2>";
    echo "<pre>" . htmlspecialchars($e->getMessage()) . "</pre>";
    echo "<h3>Stack Trace:</h3>";
    echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
    echo "</div>";
} catch (Error $e) {
    echo "<div style='background: #ffeeee; border: 2px solid red; padding: 20px; margin: 20px;'>";
    echo "<h2>Fatal Error Caught:</h2>";
    echo "<pre>" . htmlspecialchars($e->getMessage()) . "</pre>";
    echo "<h3>Stack Trace:</h3>";
    echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
    echo "</div>";
}

$output = ob_get_clean();
echo $output;

// Also log to file
file_put_contents(__DIR__ . '/install_debug.log', strip_tags($output), FILE_APPEND);
