<?php
/**
 * System Status Widget
 * Displays system health and capacity information
 */

require_once __DIR__ . '/../../includes/system_health.php';
require_once __DIR__ . '/../../includes/resource_manager.php';

// Get system capacity
$capacity = get_system_capacity();
$health = get_system_status();

// Calculate status color
$status_color = 'success';
if ($capacity['percentage'] >= 90) {
    $status_color = 'danger';
} elseif ($capacity['percentage'] >= 75) {
    $status_color = 'warning';
}

// Get license info if available
$license_info = $health['details'] ?? array();
$license_type = $license_info['license_type'] ?? 'Standard';
$customer_name = $license_info['customer_name'] ?? 'Organization';
?>

<div class="card mb-4">
    <div class="card-header bg-<?php echo $status_color; ?> text-white">
        <i class="bi bi-speedometer2"></i> System Status
    </div>
    <div class="card-body">
        <?php if (!$health['operational']): ?>
            <div class="alert alert-warning">
                <i class="bi bi-exclamation-triangle-fill"></i>
                <strong>System Notice:</strong> <?php echo htmlspecialchars($health['message']); ?>
            </div>
        <?php endif; ?>

        <div class="row mb-3">
            <div class="col-md-6">
                <h6><i class="bi bi-building"></i> Organization</h6>
                <p class="mb-0"><?php echo htmlspecialchars($customer_name); ?></p>
                <small class="text-muted">License: <?php echo htmlspecialchars($license_type); ?></small>
            </div>
            <div class="col-md-6">
                <h6><i class="bi bi-people-fill"></i> Resource Usage</h6>
                <p class="mb-0">
                    <strong><?php echo $capacity['current_usage']; ?></strong>
                    <?php if ($capacity['capacity'] !== 'unknown'): ?>
                        / <?php echo $capacity['capacity']; ?> workers
                    <?php endif; ?>
                </p>
            </div>
        </div>

        <?php if ($capacity['capacity'] !== 'unknown'): ?>
            <div class="progress mb-2" style="height: 25px;">
                <div class="progress-bar bg-<?php echo $status_color; ?>" role="progressbar"
                     style="width: <?php echo min($capacity['percentage'], 100); ?>%"
                     aria-valuenow="<?php echo $capacity['percentage']; ?>"
                     aria-valuemin="0" aria-valuemax="100">
                    <?php echo $capacity['percentage']; ?>%
                </div>
            </div>
        <?php endif; ?>

        <?php if ($capacity['percentage'] >= 90): ?>
            <div class="alert alert-danger mt-3">
                <i class="bi bi-exclamation-octagon-fill"></i>
                <strong>Capacity Warning:</strong> You are approaching your worker limit.
                <a href="upgrade.php" class="alert-link">Upgrade your license</a> to add more workers.
            </div>
        <?php elseif ($capacity['percentage'] >= 75): ?>
            <div class="alert alert-warning mt-3">
                <i class="bi bi-exclamation-triangle-fill"></i>
                <strong>Notice:</strong> You are using <?php echo $capacity['percentage']; ?>% of your capacity.
            </div>
        <?php endif; ?>

        <div class="mt-3">
            <small class="text-muted">
                <i class="bi bi-info-circle"></i>
                Status: <span class="text-<?php echo $status_color; ?>"><?php echo $health['operational'] ? 'Operational' : 'Limited'; ?></span>
            </small>
        </div>
    </div>
</div>
?>
