<?php
/**
 * License Expired Page
 * Displayed when user tries to login with an expired license
 */
session_start();

// Get license message from session
$license_message = $_SESSION['license_message'] ?? 'Your license has expired. Please renew your license to continue using the system.';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>License Expired - SCMS</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .expired-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 600px;
            width: 100%;
            overflow: hidden;
        }
        .expired-header {
            background: linear-gradient(135deg, #fbc2eb 0%, #a6c1ee 100%);
            color: #495057;
            padding: 40px;
            text-align: center;
        }
        .expired-icon {
            font-size: 80px;
            margin-bottom: 20px;
            color: #ffc107;
            animation: rotate 3s infinite ease-in-out;
        }
        @keyframes rotate {
            0%, 100% { transform: rotate(0deg); }
            25% { transform: rotate(-10deg); }
            75% { transform: rotate(10deg); }
        }
        .expired-body {
            padding: 40px;
        }
        .renewal-box {
            background: linear-gradient(135deg, #fff3cd 0%, #ffeaa7 100%);
            border-left: 4px solid #ffc107;
            padding: 20px;
            margin-top: 20px;
            border-radius: 8px;
        }
        .renewal-box h6 {
            color: #856404;
            margin-bottom: 15px;
        }
        .contact-item {
            display: flex;
            align-items: center;
            margin-bottom: 10px;
        }
        .contact-item i {
            color: #ffc107;
            margin-right: 10px;
            font-size: 18px;
        }
        .btn-back {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            color: white;
            padding: 12px 30px;
            border-radius: 25px;
            font-weight: 600;
            transition: transform 0.3s;
        }
        .btn-back:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
            color: white;
        }
        .btn-renew {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
            border: none;
            color: white;
            padding: 12px 30px;
            border-radius: 25px;
            font-weight: 600;
            transition: transform 0.3s;
            margin-right: 10px;
        }
        .btn-renew:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(240, 147, 251, 0.4);
            color: white;
        }
        .benefit-item {
            display: flex;
            align-items: start;
            margin-bottom: 12px;
        }
        .benefit-item i {
            color: #28a745;
            margin-right: 10px;
            font-size: 18px;
            margin-top: 2px;
        }
    </style>
</head>
<body>
    <div class="expired-card">
        <div class="expired-header">
            <div class="expired-icon">
                <i class="bi bi-hourglass-split"></i>
            </div>
            <h2 class="mb-0">License Expired</h2>
        </div>

        <div class="expired-body">
            <div class="alert alert-warning mb-4">
                <i class="bi bi-exclamation-triangle-fill"></i>
                <strong>Access Expired</strong>
            </div>

            <p class="mb-4">
                <?php echo htmlspecialchars($license_message); ?>
            </p>

            <div class="card bg-light border-0 mb-4">
                <div class="card-body">
                    <h6 class="mb-3"><i class="bi bi-check-circle-fill text-success"></i> Benefits of Renewing</h6>
                    <div class="benefit-item">
                        <i class="bi bi-check-circle-fill"></i>
                        <span>Continued access to UK Home Office compliance tools</span>
                    </div>
                    <div class="benefit-item">
                        <i class="bi bi-check-circle-fill"></i>
                        <span>Automatic updates and security patches</span>
                    </div>
                    <div class="benefit-item">
                        <i class="bi bi-check-circle-fill"></i>
                        <span>Priority technical support</span>
                    </div>
                    <div class="benefit-item">
                        <i class="bi bi-check-circle-fill"></i>
                        <span>Access to new features and improvements</span>
                    </div>
                    <div class="benefit-item">
                        <i class="bi bi-check-circle-fill"></i>
                        <span>Maintain your worker database and compliance records</span>
                    </div>
                </div>
            </div>

            <div class="renewal-box">
                <h6><i class="bi bi-lightning-charge-fill"></i> Renew Your License</h6>
                <p class="small mb-3">
                    Contact us to renew your license and restore full access to your system:
                </p>

                <div class="contact-item">
                    <i class="bi bi-envelope-fill"></i>
                    <span><strong>Email:</strong> <a href="mailto:abz@yours.com">abz@yours.com</a></span>
                </div>

                <div class="contact-item">
                    <i class="bi bi-telephone-fill"></i>
                    <span><strong>Phone:</strong> +44 (0) 20 1234 5678</span>
                </div>

                <div class="contact-item">
                    <i class="bi bi-clock-fill"></i>
                    <span><strong>Hours:</strong> Monday - Friday, 9:00 AM - 5:00 PM GMT</span>
                </div>
            </div>

            <div class="text-center mt-4">
                <a href="mailto:abz@yours.com?subject=License%20Renewal%20Request" class="btn btn-renew">
                    <i class="bi bi-envelope-heart"></i> Request Renewal
                </a>
                <a href="login.php" class="btn btn-back">
                    <i class="bi bi-arrow-left-circle"></i> Back to Login
                </a>
            </div>

            <div class="text-center mt-3">
                <small class="text-muted">
                    <i class="bi bi-info-circle"></i> Your data is safe. All records will be preserved after renewal.
                </small>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
