<?php
/**
 * Admin Header Include
 * Include this at the top of every admin page
 */

// Load database connection
if (!isset($pdo)) {
    require_once __DIR__ . '/../config/database.php';
}

// Load session manager (includes system health checks)
require_once __DIR__ . '/../includes/session_manager.php';

// Require authentication for all admin pages
require_authentication('../admin/login.php');

// Initialize resource monitoring
require_once __DIR__ . '/../includes/resource_manager.php';
init_resource_monitor();

// Get current user
$current_user = get_current_user();
if (!$current_user) {
    header('Location: login.php');
    exit;
}
?>
